# 进出口食品法规

本文档详细解读进出口食品的相关法规要求，用于进出口食品合规审核。

## 一、法律依据

### 1.1 《中华人民共和国进出口食品安全管理办法》（2022年）

### 1.2 《中华人民共和国食品安全法》（2021年修订）

### 1.3 《进出口食品安全管理办法》实施细则

### 1.4 海关总署相关公告

## 二、进口食品管理

### 2.1 基本要求

**第七条** 进口食品应当符合中国食品安全国家标准。

**第八条** 进口食品的境外生产企业应当获得海关总署注册。

**第十八条** 进口预包装食品应当有中文标签，标签应当符合中国法律法规和食品安全国家标准的要求。

### 2.2 境外生产企业注册

#### 2.2.1 注册要求

**需要注册的企业：**
- 肉类生产企业
- 水产品生产企业
- 乳制品生产企业
- 燕窝产品生产企业
- 蜂产品生产企业
- 其他需要注册的食品类别

**注册流程：**
1. 向所在国家（地区）主管机构申请
2. 所在国家（地区）主管机构向海关总署推荐
3. 海关总署审核并公布注册名单

#### 2.2.2 注册信息

**注册信息包括：**
- 企业名称
- 地址
- 国家（地区）
- 产品类别
- 注册编号

#### 2.2.3 注册有效期

- 有效期一般为4年
- 有效期届满前需申请延续注册

### 2.3 进口食品标签要求

#### 2.3.1 中文标签必备内容

**必须标示：**
1. 食品名称
2. 配料表
3. 净含量和规格
4. 生产者、经销者名称、地址、联系方式
5. 生产日期和保质期
6. 贮存条件
7. 原产国（地区）
8. 进口商/经销商信息
9. 食品生产许可证编号（如适用）

#### 2.3.2 标签格式要求

**要求：**
- 必须使用中文
- 字体清晰易读
- 标签内容完整准确
- 符合GB 7718和GB 28050要求

#### 2.3.3 原标签保留

**要求：**
- 原外文标签可保留
- 中文标签应覆盖或并列标示
- 中外文内容应一致

### 2.4 进口食品检验检疫

#### 2.4.1 检验检疫要求

**必检项目：**
- 感官检验
- 标签检验
- 现场查验
- 实验室检测

**检测项目：**
- 微生物指标
- 理化指标
- 食品添加剂
- 农药残留
- 兽药残留
- 重金属
- 污染物

#### 2.4.2 检验检疫证明

**需要提供的证明：**
1. 原产地证书
2. 卫生证书/健康证书
3. 检疫证书
4. 检测报告
5. 其他要求的证明文件

#### 2.4.3 不合格处理

**不合格情形：**
- 不符合中国标准
- 标签不合格
- 证明文件缺失
- 检测不合格

**处理方式：**
- 退运
- 销毁
- 技术处理（如适用）

### 2.5 特殊进口食品

#### 2.5.1 保健食品

**要求：**
- 需取得进口保健食品注册证书
- 需有"蓝帽子"标志
- 标签需符合保健食品要求

#### 2.5.2 特殊医学用途配方食品

**要求：**
- 需取得注册证书
- 需有中文标签
- 需注明使用方法

#### 2.5.3 婴幼儿配方食品

**要求：**
- 需取得产品配方注册
- 需有中文标签
- 需符合中国标准

#### 2.5.4 新食品原料

**要求：**
- 需取得新食品原料批准
- 需符合使用范围和用量
- 需有中文标签

## 三、出口食品管理

### 3.1 基本要求

**第三十条** 出口食品生产企业应当获得海关总署备案。

**第三十一条** 出口食品应当符合进口国家（地区）的标准或者合同要求。

**第三十二条** 出口食品生产企业应当建立完善的质量安全管理体系。

### 3.2 出口生产企业备案

#### 3.2.1 备案条件

**需满足：**
1. 具有合法的生产资质
2. 建立食品安全管理制度
3. 建立追溯体系
4. 生产场所符合要求
5. 有专业技术人员

#### 3.2.2 备案流程

**步骤：**
1. 向所在地海关申请
2. 提交备案材料
3. 海关审核
4. 公布备案名单

#### 3.2.3 备案材料

**需提交：**
1. 备案申请表
2. 营业执照
3. 生产许可证
4. 食品安全管理制度
5. 厂区平面图
6. 工艺流程图
7. 其他要求的材料

### 3.3 出口食品检验检疫

#### 3.3.1 检验要求

**检验内容：**
- 原料检验
- 生产过程检验
- 成品检验
- 标签检验

#### 3.3.2 检疫要求

**检疫内容：**
- 动植物检疫
- 卫生检疫
- 其他要求的检疫

#### 3.3.3 证书要求

**需提供的证书：**
1. 原产地证书
2. 卫生证书
3. 植物检疫证书（如适用）
4. 其他要求的证书

### 3.4 出口食品标签要求

#### 3.4.1 基本要求

**要求：**
- 符合进口国（地区）标准
- 符合合同约定
- 内容真实准确

#### 3.4.2 常见进口国要求

**美国（FDA）：**
- 必须有英文标签
- 标注营养成分
- 标注过敏原

**欧盟：**
- 必须有成员国语言标签
- 标注过敏原
- 标注原产地

**日本：**
- 必须有日文标签
- 标注过敏原
- 标注添加剂

**韩国：**
- 必须有韩文标签
- 标注营养成分
- 标注过敏原

### 3.5 出口食品特殊要求

#### 3.5.1 有机食品

**要求：**
- 需取得有机认证
- 符合进口国有机标准
- 有机标志使用规范

#### 3.5.2 清真食品

**要求：**
- 需取得清真认证
- 符合清真标准
- 清真标志使用规范

#### 3.5.3 犹太食品

**要求：**
- 需取得犹太认证
- 符合犹太标准
- 犹太标志使用规范

## 四、常见进出口食品问题

### 4.1 进口食品常见问题

| 问题类型 | 具体表现 | 整改建议 |
|---------|---------|---------|
| 标签问题 | 无中文标签、标签不完整 | 加贴中文标签 |
| 标准不符 | 不符合中国标准 | 退运或销毁 |
| 证明缺失 | 缺少原产地证书等 | 补充证明文件 |
| 企业未注册 | 境外企业未注册 | 办理注册手续 |
| 检测不合格 | 检测指标超标 | 退运或销毁 |

### 4.2 出口食品常见问题

| 问题类型 | 具体表现 | 整改建议 |
|---------|---------|---------|
| 标签问题 | 不符合进口国要求 | 调整标签 |
| 标准不符 | 不符合进口国标准 | 调整产品 |
| 企业未备案 | 未办理备案 | 办理备案手续 |
| 证书缺失 | 缺少必要证书 | 补充证书 |
| 检测不合格 | 检测指标超标 | 调整产品 |

## 五、进出口食品审核流程

### 5.1 进口食品审核

#### 5.1.1 资料审核

**检查项目：**
- [ ] 原产地证书
- [ ] 卫生证书
- [ ] 检疫证书
- [ ] 检测报告
- [ ] 合同、发票
- [ ] 装箱单

#### 5.1.2 标签审核

**检查项目：**
- [ ] 中文标签是否完整
- [ ] 标签内容是否准确
- [ ] 标签格式是否规范
- [ ] 是否符合GB标准

#### 5.1.3 标准审核

**检查项目：**
- [ ] 是否符合中国标准
- [ ] 是否符合进口国标准
- [ ] 特殊食品是否有注册

#### 5.1.4 企业审核

**检查项目：**
- [ ] 境外企业是否注册
- [ ] 注册信息是否准确
- [ ] 注册是否有效

### 5.2 出口食品审核

#### 5.2.1 资料审核

**检查项目：**
- [ ] 企业是否备案
- [ ] 备案是否有效
- [ ] 生产许可证是否有效
- [ ] 产品标准是否明确

#### 5.2.2 标签审核

**检查项目：**
- [ ] 标签是否符合进口国要求
- [ ] 标签内容是否准确
- [ ] 语言是否正确
- [ ] 特殊标志是否合规

#### 5.2.3 标准审核

**检查项目：**
- [ ] 是否符合进口国标准
- [ ] 是否符合中国标准
- [ ] 是否符合合同约定

#### 5.2.4 证书审核

**检查项目：**
- [ ] 原产地证书
- [ ] 卫生证书
- [ ] 植物检疫证书（如适用）
- [ ] 其他要求的证书

## 六、主要贸易伙伴国要求

### 6.1 美国（FDA）

**主要法规：**
- FD&C Act
- FSMA法案
- 标签法规

**重点要求：**
- 食品企业注册
- 进口预申报
- 标签要求
- 过敏原标注

### 6.2 欧盟（EFSA）

**主要法规：**
- EC No 178/2002
- EC No 852/2004
- EC No 1881/2006

**重点要求：**
- 食品企业注册
- 追溯体系
- 标签要求
- 过敏原标注

### 6.3 日本（MHLW）

**主要法规：**
- 食品卫生法
- 肯定列表制度

**重点要求：**
- 农药残留标准
- 添加剂标准
- 标签要求
- 过敏原标注

### 6.4 韩国（MFDS）

**主要法规：**
- 食品卫生法
- 食品等标示标准

**重点要求：**
- 食品企业注册
- 标签要求
- 营养成分标注
- 过敏原标注

### 6.5 东南亚国家

**主要法规：**
- 各国食品安全法
- 东盟标准

**重点要求：**
- 标签要求
- 添加剂标准
- 微生物标准

## 七、进出口食品审核检查清单

### 7.1 进口食品检查

#### 资料检查
- [ ] 原产地证书
- [ ] 卫生证书
- [ ] 检疫证书
- [ ] 检测报告
- [ ] 其他证明文件

#### 标签检查
- [ ] 中文标签
- [ ] 标签内容完整
- [ ] 标签格式规范
- [ ] 符合GB标准

#### 合规性检查
- [ ] 符合中国标准
- [ ] 境外企业已注册
- [ ] 特殊食品有注册
- [ ] 检测合格

### 7.2 出口食品检查

#### 资料检查
- [ ] 企业已备案
- [ ] 生产许可证有效
- [ ] 产品标准明确
- [ ] 证书齐全

#### 标签检查
- [ ] 符合进口国要求
- [ ] 标签内容准确
- [ ] 语言正确
- [ ] 特殊标志合规

#### 合规性检查
- [ ] 符合进口国标准
- [ ] 符合中国标准
- [ ] 符合合同约定
- [ ] 检测合格

---

**注意：** 进出口食品法规不断更新，具体审核时应查阅最新法规和进口国要求。如有复杂问题，建议咨询专业报关行或法律顾问。
