# 食品添加剂使用规范

本文档详细解读GB 2760-2014标准，用于食品添加剂合规审核。

## 一、GB 2760-2014标准概述

### 1.1 适用范围

适用于所有食品添加剂的生产、经营和使用，包括：
- 食品用香料
- 食品工业用加工助剂
- 胶基糖果中基础剂物质

### 1.2 基本原则

**2.1** 食品添加剂的使用应符合以下要求：
1. 不应对人体产生任何健康危害
2. 不应掩盖食品腐败变质
3. 不应掩盖食品本身或加工过程中的质量缺陷
4. 不应降低食品本身的营养价值
5. 在达到预期效果的前提下尽可能降低使用量

### 1.3 使用范围和用量的确定

食品添加剂的使用应符合附录A中规定的使用范围及使用量。

## 二、食品添加剂分类

### 2.1 按功能分类（共23类）

| 类别代码 | 类别名称 | 常见添加剂 |
|---------|---------|-----------|
| 01 | 酸度调节剂 | 柠檬酸、乳酸 |
| 02 | 抗结剂 | 二氧化硅 |
| 03 | 消泡剂 | 聚二甲基硅氧烷 |
| 04 | 抗氧化剂 | 维生素C、维生素E |
| 05 | 漂白剂 | 亚硫酸钠 |
| 06 | 膨松剂 | 碳酸氢钠 |
| 07 | 胶基糖果中基础剂物质 | 胶基 |
| 08 | 着色剂 | 诱惑红、柠檬黄 |
| 09 | 护色剂 | 亚硝酸钠 |
| 10 | 乳化剂 | 单甘油脂肪酸酯 |
| 11 | 酶制剂 | 木瓜蛋白酶 |
| 12 | 增味剂 | 谷氨酸钠（味精） |
| 13 | 面粉处理剂 | 抗坏血酸 |
| 14 | 被膜剂 | 果蜡 |
| 15 | 水分保持剂 | 三聚磷酸钠 |
| 16 | 营养强化剂 | 维生素A、铁 |
| 17 | 防腐剂 | 苯甲酸钠、山梨酸钾 |
| 18 | 稳定剂和凝固剂 | 卡拉胶 |
| 19 | 甜味剂 | 阿斯巴甜、三氯蔗糖 |
| 20 | 增稠剂 | 黄原胶、果胶 |
| 21 | 食品用香料 | 天然香料、合成香料 |
| 22 | 食品工业用加工助剂 | 活性炭 |
| 23 | 其他 | 二氧化碳 |

### 2.2 按使用情况分类

| 分类 | 说明 | 示例 |
|-----|------|------|
| 通用添加剂 | 多类食品可用 | 防腐剂、抗氧化剂 |
| 专用添加剂 | 特定食品类别使用 | 护色剂（肉类）、漂白剂（面粉） |
| 禁用添加剂 | 不得在食品中使用 | 吊白块、苏丹红 |

## 三、常用食品添加剂详解

### 3.1 防腐剂

#### 3.1.1 苯甲酸及苯甲酸钠

**CNS号：** 17.001, 17.002

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 01.05.01 | 碳酸饮料 | 0.2 |
| 03.01 | 酱油 | 1.0 |
| 04.01.02.05 | 果酱 | 1.0 |
| 04.04.01.02 | 果蔬汁（浆） | 1.0 |
| 07.01 | 面包 | 1.0 |
| 07.02 | 糕点 | 1.0 |
| 14.02.01 | 果蔬汁饮料 | 1.0 |

**注意事项：**
- 不得用于婴幼儿食品
- 与山梨酸钾复配使用时总量不超过1.0 g/kg

#### 3.1.2 山梨酸及山梨酸钾

**CNS号：** 17.003, 17.004

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 01.05.01 | 碳酸饮料 | 0.2 |
| 03.01 | 酱油 | 1.0 |
| 04.01.02.05 | 果酱 | 1.0 |
| 06.03.02.01 | 生湿面制品 | 0.25 |
| 07.01 | 面包 | 1.0 |
| 07.02 | 糕点 | 1.0 |
| 14.02.01 | 果蔬汁饮料 | 0.5 |

**注意事项：**
- 防腐效果优于苯甲酸钠
- 无异味，适用范围广

#### 3.1.3 丙酸及丙酸盐

**CNS号：** 17.029, 17.030, 17.031

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 06.03.02.01 | 生湿面制品 | 0.25 |
| 07.01 | 面包 | 2.5 |
| 07.02 | 糕点 | 2.5 |

**注意事项：**
- 主要用于面包、糕点防霉
- 对霉菌抑制效果好

### 3.2 抗氧化剂

#### 3.2.1 丁基羟基茴香醚（BHA）

**CNS号：** 04.001

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 02.01.01.01 | 植物油脂 | 0.2 |
| 02.01.01.02 | 动物油脂 | 0.2 |
| 06.03.02.01 | 方便米面制品 | 0.2 |
| 07.03 | 饼干 | 0.2 |

**注意事项：**
- 与BHT、PG复配使用
- 总量不超过0.2 g/kg

#### 3.2.2 二丁基羟基甲苯（BHT）

**CNS号：** 04.002

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 02.01.01.01 | 植物油脂 | 0.2 |
| 02.01.01.02 | 动物油脂 | 0.2 |
| 06.03.02.01 | 方便米面制品 | 0.2 |
| 07.03 | 饼干 | 0.2 |

**注意事项：**
- 与BHA、PG复配使用
- 总量不超过0.2 g/kg

#### 3.2.3 没食子酸丙酯（PG）

**CNS号：** 04.003

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 02.01.01.01 | 植物油脂 | 0.1 |
| 02.01.01.02 | 动物油脂 | 0.1 |
| 06.03.02.01 | 方便米面制品 | 0.1 |

**注意事项：**
- 与BHA、BHT复配使用
- 总量不超过0.2 g/kg

### 3.3 甜味剂

#### 3.3.1 糖精钠

**CNS号：** 19.001

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 03.0 | 调味品 | 0.15 |
| 04.01.02.08.02 | 蜜饯凉果 | 5.0 |
| 07.02 | 糕点 | 0.15 |
| 14.02.03 | 果蔬汁饮料 | 0.15 |
| 16.01 | 果冻 | 0.15 |

**注意事项：**
- 不得用于婴幼儿食品
- 需标注"本品含糖精钠"

#### 3.3.2 环己基氨基磺酸钠（甜蜜素）

**CNS号：** 19.002

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 03.0 | 调味品 | 0.65 |
| 04.01.02.08.02 | 蜜饯凉果 | 1.0 |
| 07.02 | 糕点 | 1.6 |
| 14.02.03 | 果蔬汁饮料 | 0.65 |
| 16.01 | 果冻 | 0.65 |

**注意事项：**
- 不得用于婴幼儿食品
- 与糖精钠复配使用

#### 3.3.3 三氯蔗糖

**CNS号：** 19.016

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 01.05.01 | 碳酸饮料 | 0.25 |
| 04.01.02.08.02 | 蜜饯凉果 | 1.5 |
| 07.02 | 糕点 | 0.15 |
| 14.02.03 | 果蔬汁饮料 | 0.25 |
| 16.01 | 果冻 | 0.45 |

**注意事项：**
- 甜度高，使用量小
- 稳定性好

### 3.4 着色剂

#### 3.4.1 柠檬黄

**CNS号：** 08.005

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 04.01.02.05 | 果酱 | 0.5 |
| 04.02.02.03 | 水果罐头 | 0.1 |
| 07.02 | 糕点 | 0.1 |
| 14.02.03 | 果蔬汁饮料 | 0.1 |
| 16.01 | 果冻 | 0.05 |

**注意事项：**
- 可能引起过敏反应
- 需标注含柠檬黄

#### 3.4.2 日落黄

**CNS号：** 08.006

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 04.01.02.05 | 果酱 | 0.5 |
| 07.02 | 糕点 | 0.1 |
| 14.02.03 | 果蔬汁饮料 | 0.1 |
| 16.01 | 果冻 | 0.05 |

**注意事项：**
- 与柠檬黄复配使用
- 可能引起过敏反应

#### 3.4.3 胭脂红

**CNS号：** 08.002

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 03.01 | 酱油 | 0.05 |
| 04.01.02.05 | 果酱 | 0.5 |
| 07.02 | 糕点 | 0.05 |
| 16.01 | 果冻 | 0.05 |

**注意事项：**
- 不得用于肉类制品
- 可能引起过敏反应

### 3.5 乳化剂

#### 3.5.1 单甘油脂肪酸酯

**CNS号：** 10.006

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 01.01.02 | 调制乳 | 5.0 |
| 01.02.02 | 发酵乳 | 5.0 |
| 02.01.01.02 | 人造黄油 | 20.0 |
| 06.03.02.01 | 生湿面制品 | 按生产需要适量使用 |
| 07.01 | 面包 | 6.0 |
| 07.02 | 糕点 | 3.0 |

**注意事项：**
- 使用范围广
- 用量灵活

#### 3.5.2 蔗糖脂肪酸酯

**CNS号：** 10.001

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 01.01.02 | 调制乳 | 3.0 |
| 02.01.01.02 | 人造黄油 | 10.0 |
| 06.03.02.01 | 生湿面制品 | 4.0 |
| 07.01 | 面包 | 3.0 |
| 07.02 | 糕点 | 3.0 |

**注意事项：**
- 乳化效果好
- 适用范围广

### 3.6 增稠剂

#### 3.6.1 黄原胶

**CNS号：** 20.009

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 01.05.01 | 碳酸饮料 | 2.0 |
| 02.02.01.01 | 生湿面制品 | 10.0 |
| 06.03.02.01 | 方便米面制品 | 10.0 |
| 14.02.03 | 果蔬汁饮料 | 2.0 |
| 16.01 | 果冻 | 3.0 |

**注意事项：**
- 增稠效果好
- 耐酸、耐盐

#### 3.6.2 卡拉胶

**CNS号：** 20.007

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 01.02.02 | 发酵乳 | 0.04 |
| 03.01 | 酱油 | 1.0 |
| 14.02.03 | 果蔬汁饮料 | 0.3 |
| 16.01 | 果冻 | 按生产需要适量使用 |

**注意事项：**
- 凝胶强度高
- 与蛋白质相容性好

#### 3.6.3 果胶

**CNS号：** 20.006

**使用范围及最大使用量：**

| 食品分类号 | 食品名称 | 最大使用量(g/kg) |
|-----------|---------|-----------------|
| 04.01.02.05 | 果酱 | 按生产需要适量使用 |
| 14.02.03 | 果蔬汁饮料 | 3.0 |
| 16.01 | 果冻 | 10.0 |

**注意事项：**
- 天然提取物
- 安全性高

## 四、禁用添加剂

### 4.1 严禁使用的添加剂

| 添加剂名称 | 危害 | 曾用场景 |
|-----------|------|---------|
| 吊白块 | 致癌 | 面粉、腐竹 |
| 苏丹红 | 致癌 | 辣椒粉、咸鸭蛋 |
| 王金黄、块黄 | 致癌 | 腐竹、豆制品 |
| 三聚氰胺 | 肾脏损害 | 乳制品 |
| 瘦肉精 | 心脏损害 | 猪肉 |
| 孔雀石绿 | 致癌 | 水产品 |
| 甲醛 | 致癌 | 水发食品 |
| 硼砂 | 中毒 | 肉丸、粽子 |

### 4.2 非法添加物

| 添加物 | 危害 | 曾用场景 |
|--------|------|---------|
| 罗丹明B | 致癌 | 辣椒粉 |
| 碱性橙 | 致癌 | 豆制品 |
| 工业硫磺 | 呼吸系统损害 | 干果、竹笋 |
| 工业用火碱 | 化学灼伤 | 水发食品 |

## 五、复合食品添加剂

### 5.1 定义

由两种或两种以上食品添加剂经物理混合而成的添加剂。

### 5.2 标注要求

**配料表中应标示：**
1. 复合食品添加剂的名称
2. 各单一食品添加剂的通用名称

**示例：**
- 复合防腐剂（山梨酸钾、苯甲酸钠）
- 复合抗氧化剂（维生素C、维生素E）

### 5.3 使用要求

- 应符合各单一添加剂的使用范围和用量
- 复合后各单一添加剂的用量不得超过最大使用量

## 六、添加剂审核流程

### 6.1 识别添加剂

**步骤：**
1. 从配料表中识别所有添加剂
2. 确认添加剂的通用名称
3. 确认是否为复合添加剂

### 6.2 确定产品类别

**步骤：**
1. 根据产品名称确定食品分类号
2. 确认产品类别
3. 查询该类别的允许使用范围

### 6.3 查询使用标准

**步骤：**
1. 查询GB 2760附录A
2. 确认添加剂是否允许在该类别使用
3. 确认最大使用量

### 6.4 计算使用量

**步骤：**
1. 根据配方计算实际使用量
2. 与最大使用量比较
3. 判断是否合规

### 6.5 检查标注

**步骤：**
1. 检查是否使用通用名称
2. 检查复合添加剂是否展开
3. 检查是否有必要标注

## 七、常见问题及整改建议

### 7.1 超范围使用

| 问题 | 示例 | 整改建议 |
|-----|------|---------|
| 在不允许的类别中使用 | 面包中使用护色剂 | 停止使用 |
| 使用禁用添加剂 | 腐竹中使用吊白块 | 立即停止，销毁产品 |

### 7.2 超限量使用

| 问题 | 示例 | 整改建议 |
|-----|------|---------|
| 超过最大使用量 | 防腐剂用量超标 | 调整配方 |
| 复配后总量超标 | 多种防腐剂复配超限 | 调整配方 |

### 7.3 标注不规范

| 问题 | 示例 | 整改建议 |
|-----|------|---------|
| 未使用通用名称 | 标注"防腐剂" | 改为"山梨酸钾" |
| 复合添加剂未展开 | 标注"复合防腐剂" | 展开为"山梨酸钾、苯甲酸钠" |

## 八、添加剂审核检查清单

### 8.1 基础检查
- [ ] 所有添加剂是否已识别
- [ ] 产品类别是否准确
- [ ] 是否有禁用添加剂

### 8.2 合规性检查
- [ ] 添加剂是否在允许范围内
- [ ] 使用量是否超限
- [ ] 复配是否合规

### 8.3 标注检查
- [ ] 是否使用通用名称
- [ ] 复合添加剂是否展开
- [ ] 标注是否完整

---

**注意：** 本文档为GB 2760-2014标准摘要，具体审核时应查阅完整标准。如有疑问，建议咨询专业检测机构。
