# 广告合规指南

本文档详细解读食品广告宣传的合规要求，用于食品广告内容审核。

## 一、法律依据

### 1.1 《中华人民共和国广告法》（2021年修订）

### 1.2 《中华人民共和国食品安全法》（2021年修订）

### 1.3 《互联网广告管理办法》（2023年修订）

### 1.4 《食品广告发布暂行规定》

## 二、禁止性内容

### 2.1 绝对禁止的内容（广告法第九条）

| 禁止内容 | 违规示例 | 法律后果 |
|---------|---------|---------|
| 使用或变相使用国旗、国歌、国徽 | "中国第一XX" | 罚款20-100万元 |
| 使用国家机关名义 | "XX协会推荐" | 罚款20-100万元 |
| 使用"国家级""最高级""最佳"等用语 | "最健康饮品""顶级品质" | 罚款20-100万元 |
| 妨碍社会公共秩序 | 宣传迷信、低俗内容 | 罚款20-100万元 |
| 泄露个人隐私 | 使用他人肖像未授权 | 罚款20-100万元 |
| 含有淫秽、色情内容 | 低俗暗示 | 罚款20-100万元 |
| 含有赌博、迷信内容 | "喝了XX必中彩票" | 罚款20-100万元 |
| 危害人身、财产安全 | "空腹喝XX治病" | 罚款20-100万元 |

### 2.2 食品广告特别禁止内容（食品安全法第七十三条）

| 禁止内容 | 违规示例 | 法律后果 |
|---------|---------|---------|
| 涉及疾病预防、治疗功能 | "治疗高血压""降糖" | 罚款10-200万元 |
| 声称保健功能（非保健食品） | "增强免疫力""延缓衰老" | 罚款10-200万元 |
| 使用医疗用语 | "排毒""消炎""调理" | 罚款10-200万元 |
| 虚假宣传功效 | "三天减肥10斤" | 罚款10-200万元 |
| 夸大宣传 | "包治百病" | 罚款10-200万元 |

### 2.3 保健食品广告禁止内容（广告法第十八条）

| 禁止内容 | 违规示例 | 法律后果 |
|---------|---------|---------|
| 表示功效、安全性的断言 | "保证有效""无副作用" | 罚款10-200万元 |
| 涉及疾病预防、治疗功能 | "治疗糖尿病" | 罚款10-200万元 |
| 声称或暗示为保障健康所必需 | "每天必喝" | 罚款10-200万元 |
| 与药品、其他保健食品比较 | "比XX药效果好" | 罚款10-200万元 |
| 利用广告代言人作推荐、证明 | 明星代言保健食品 | 罚款10-200万元 |

## 三、限制性内容

### 3.1 需谨慎使用的词汇

| 类别 | 词汇 | 使用建议 |
|-----|------|---------|
| 绝对化类 | 最、第一、顶级、极品 | ❌ 禁止使用 |
| 夸大功效类 | 奇迹、神奇、特效 | ❌ 禁止使用 |
| 医疗类 | 治疗、消炎、排毒、调理 | ❌ 禁止使用 |
| 保证类 | 保证、包治、绝对 | ❌ 禁止使用 |
| 对比类 | 比XX好、超越XX | ⚠ 需有科学依据 |
| 功能类 | 增强免疫、延缓衰老 | ⚠ 仅限保健食品 |

### 3.2 可使用的表述

**描述性表述（✓ 可用）：**
- "富含维生素C"（需有检测报告）
- "低糖""低脂"（需符合标准）
- "自然""新鲜"（需符合实际）
- "传统工艺""精选原料"（需属实）

**功能性表述（⚠ 需谨慎）：**
- "补充营养"（需有依据）
- "清爽解渴"（需符合实际）
- "易于消化"（需有依据）

## 四、特殊食品广告要求

### 4.1 保健食品广告

**必备要素：**
1. "蓝帽子"标志
2. "本品不能代替药物"声明
3. 保健食品批准证书号
4. "不适宜人群"提示

**可声称功能（27种）：**
1. 增强免疫力
2. 辅助降血脂
3. 辅助降血糖
4. 抗氧化
5. 辅助改善记忆
6. 缓解视疲劳
7. 促进排铅
8. 清咽
9. 辅助降血压
10. 改善睡眠
11. 促进泌乳
12. 缓解体力疲劳
13. 提高缺氧耐受力
14. 对辐射危害有辅助保护功能
15. 减肥
16. 改善生长发育
17. 增加骨密度
18. 改善营养性贫血
19. 对化学性肝损伤有辅助保护功能
20. 祛痤疮
21. 祛黄褐斑
22. 改善皮肤水分
23. 改善皮肤油分
24. 调节肠道菌群
25. 促进消化
26. 通便
27. 对胃粘膜有辅助保护功能

**禁止声称：**
- 治疗疾病
- 预防疾病
- 比药物效果好
- 无副作用
- 立即见效

### 4.2 特殊医学用途配方食品广告

**要求：**
- 需取得注册证书
- 只能在医疗机构销售
- 广告中需注明"特殊医学用途"
- 需在医生或临床营养师指导下使用

### 4.3 婴幼儿配方食品广告

**要求：**
- 不得宣传替代母乳
- 不得使用婴儿形象
- 不得使用"最""第一"等绝对化用语
- 不得暗示产品优于母乳

## 五、网络广告特殊要求

### 5.1 互联网广告标识

**要求：**
- 必须显著标明"广告"
- 不得使消费者误认为是自然内容
- 标识应当清晰、醒目

### 5.2 社交媒体广告

**要求：**
- KOL推广需标注"广告"或"推广"
- 软文广告需明确标识
- 不得隐瞒商业推广性质

### 5.3 直播带货广告

**要求：**
- 直播中宣传需符合广告法
- 不得虚假宣传
- 不得使用绝对化用语
- 保健食品不得由普通消费者推荐

## 六、广告审核流程

### 6.1 初步审核

**检查项目：**
- [ ] 是否有绝对化用语
- [ ] 是否涉及疾病治疗
- [ ] 是否使用医疗用语
- [ ] 是否有虚假内容
- [ ] 是否有误导性表述

### 6.2 内容审核

**检查项目：**
- [ ] 宣传内容是否有科学依据
- [ ] 数据来源是否可靠
- [ ] 对比是否客观
- [ ] 功能声称是否合规

### 6.3 形式审核

**检查项目：**
- [ ] 广告标识是否清晰
- [ ] 保健食品是否有蓝帽子
- [ ] 是否有"不能代替药物"提示
- [ ] 是否有不适宜人群提示

## 七、常见违规案例

### 7.1 绝对化用语案例

| 违规广告 | 问题 | 整改建议 |
|---------|------|---------|
| "最健康的饮料" | 使用"最" | 改为"健康饮品" |
| "第一品牌" | 使用"第一" | 改为"知名品牌" |
| "顶级品质" | 使用"顶级" | 改为"优质品质" |
| "最佳选择" | 使用"最佳" | 改为"优质选择" |

### 7.2 医疗用语案例

| 违规广告 | 问题 | 整改建议 |
|---------|------|---------|
| "降糖茶" | 涉及治疗功能 | 改为"低糖茶" |
| "排毒养颜" | 使用医疗用语 | 改为"美容养颜" |
| "调理肠胃" | 使用医疗用语 | 改为"呵护肠胃" |
| "消炎杀菌" | 使用医疗用语 | 删除或改用其他表述 |

### 7.3 功能声称案例

| 违规广告 | 问题 | 整改建议 |
|---------|------|---------|
| "增强免疫力"（普通食品） | 非保健食品声称功能 | 删除或取得保健食品资质 |
| "延缓衰老"（普通食品） | 非保健食品声称功能 | 删除或取得保健食品资质 |
| "三天减肥10斤" | 虚假宣传 | 删除或提供科学依据 |
| "包治百病" | 虚假宣传 | 删除 |

### 7.4 代言人案例

| 违规情况 | 问题 | 法律后果 |
|---------|------|---------|
| 明星代言保健食品 | 违反代言人规定 | 罚款10-200万元 |
| 明星代言未使用产品 | 违反真实性原则 | 罚款10-200万元 |
| 未成年人在食品广告中 | 违反未成年人保护 | 罚款10-200万元 |

## 八、合规建议

### 8.1 广告创意阶段

**建议：**
- 提前进行法律审核
- 避免使用绝对化用语
- 不涉及疾病治疗
- 确保内容真实

### 8.2 广告制作阶段

**建议：**
- 保存所有素材的依据
- 检测数据需有报告
- 对比宣传需客观
- 标识清晰醒目

### 8.3 广告发布阶段

**建议：**
- 定期检查广告内容
- 及时更新过期信息
- 建立审核机制
- 保留发布记录

### 8.4 争议处理

**建议：**
- 建立快速响应机制
- 及时撤下问题广告
- 主动配合调查
- 完善内部流程

## 九、广告审核检查清单

### 9.1 基础检查
- [ ] 是否有"广告"标识
- [ ] 广告内容是否真实
- [ ] 是否有误导性表述

### 9.2 禁止内容检查
- [ ] 是否有绝对化用语
- [ ] 是否涉及疾病治疗
- [ ] 是否使用医疗用语
- [ ] 是否有虚假内容

### 9.3 功能声称检查
- [ ] 功能声称是否有依据
- [ ] 保健食品是否有蓝帽子
- [ ] 是否有"不能代替药物"提示
- [ ] 是否有不适宜人群提示

### 9.4 代言人检查
- [ ] 代言人是否使用过产品
- [ ] 是否有未成年人代言
- [ ] 保健食品是否有代言人

### 9.5 网络广告检查
- [ ] 是否有"广告"标识
- [ ] 软文是否标注推广
- [ ] 直播内容是否合规

---

**注意：** 广告法规不断更新，具体审核时应查阅最新法规条文。如有复杂问题，建议咨询专业法律顾问。
