---
name: food-safety-legal
description: 食品安全法律审核专家。提供中国食品饮料行业的法律合规审核服务，包括：食品安全法合规审查、食品标签规范审核、饮料行业标准检查、进出口食品法规分析、食品添加剂使用合规性评估、营养成分表审核、广告宣传合规性检查、HACCP体系认证指导、食品生产许可(SC)审核、食品召回法律风险评估。当用户需要审核食品饮料产品的法律合规性、检查标签规范、评估广告合规性、或进行食品安全法律咨询时使用此技能。
---

# 食品安全法律审核技能

## 核心功能

本技能专注于中国食品饮料行业的法律合规审核，涵盖从产品标签到广告宣传的全方位合规检查。

## 审核流程

### 第一步：识别审核类型

根据用户需求确定审核类型：

| 审核类型 | 适用场景 | 关键法规 |
|---------|---------|---------|
| **食品标签审核** | 预包装食品标签设计、印刷前审核 | GB 7718-2011、GB 28050-2011 |
| **饮料标准审核** | 各类饮料产品标准符合性检查 | GB/T 10789、GB 7101等 |
| **广告合规审核** | 食品广告宣传内容审核 | 《广告法》《食品安全法》 |
| **进出口审核** | 进出口食品法规符合性 | 海关总署相关法规 |
| **添加剂审核** | 食品添加剂使用合规性 | GB 2760-2014 |
| **生产许可审核** | 食品生产许可证(SC)相关 | 《食品生产许可管理办法》 |

### 第二步：收集必要信息

向用户询问以下信息（根据审核类型选择）：

**基础信息：**
- 产品名称和类型
- 产品类别（预包装/散装、普通/特殊膳食用等）
- 目标市场（国内/出口）

**标签审核需提供：**
- 标签设计稿或图片
- 产品配料表
- 营养成分表
- 生产商信息
- 产品标准号

**广告审核需提供：**
- 广告文案或脚本
- 宣传图片/视频
- 宣传渠道

**进出口审核需提供：**
- 原产国/目的国
- 产品HS编码
- 检验检疫要求

### 第三步：执行合规检查

根据审核类型，加载相应的参考文件：

- **标签审核**：读取 `references/labeling-standards.md`
- **广告审核**：读取 `references/advertising-compliance.md`
- **添加剂审核**：读取 `references/food-additives.md`
- **进出口审核**：读取 `references/import-export-regs.md`
- **生产许可**：读取 `references/production-license.md`

### 第四步：生成审核报告

审核报告应包含以下部分：

1. **执行摘要** - 审核类型、范围、主要发现
2. **合规性评估** - 逐项检查结果（✓ 合规 / ⚠ 需改进 / ✗ 不合规）
3. **风险分析** - 识别的合规风险及严重程度
4. **整改建议** - 具体的修改建议和行动项
5. **法规依据** - 引用的具体法规条款

## 常见审核要点

### 食品标签审核要点

**必检项目：**
- [ ] 食品名称是否规范
- [ ] 配料表是否完整准确（按递减顺序排列）
- [ ] 净含量和规格标注是否正确
- [ ] 生产者/经销者信息是否完整
- [ ] 生产日期和保质期标注是否规范
- [ ] 贮存条件是否明确
- [ ] 食品生产许可证编号（SC）是否正确
- [ ] 产品标准代号是否有效
- [ ] 营养成分表是否符合GB 28050要求
- [ ] 营养声称是否合规
- [ ] 过敏原提示是否完整

**常见问题：**
- 配料表未按重量递减顺序排列
- 营养成分表数值计算错误
- 使用了未经批准的功能声称
- 过敏原信息缺失或标注不规范
- 生产许可证编号格式错误

### 广告宣传审核要点

**禁止性内容：**
- 不得使用"最""第一"等绝对化用语
- 不得宣传疾病预防、治疗功能
- 不得虚假宣传功效
- 不得使用医疗用语
- 不得欺骗或误导消费者

**需谨慎内容：**
- 功能性声称需有科学依据
- 对比宣传需客观真实
- 代言人使用需符合规定
- 特殊食品（保健食品等）有额外限制

### 食品添加剂审核要点

**检查流程：**
1. 识别产品中所有添加剂
2. 确认产品类别
3. 查询GB 2760中该类别的允许使用范围
4. 核对最大使用量
5. 检查是否为复合食品添加剂

**常见问题：**
- 超范围使用添加剂
- 超限量使用添加剂
- 使用了禁止的添加剂
- 复合添加剂未标明各成分

## 输出格式

### 审核报告模板

```markdown
# 食品安全法律审核报告

**审核编号：** FS-[日期]-[序号]
**审核日期：** YYYY-MM-DD
**审核类型：** [标签/广告/添加剂等]
**产品名称：** [产品名称]

---

## 一、执行摘要

[简要说明审核范围、主要发现和总体结论]

## 二、合规性评估

| 检查项目 | 状态 | 说明 |
|---------|------|------|
| 项目1 | ✓/⚠/✗ | [详细说明] |
| 项目2 | ✓/⚠/✗ | [详细说明] |

## 三、风险分析

### 高风险项
- [风险1]：[描述和影响]

### 中风险项
- [风险2]：[描述和影响]

### 低风险项
- [风险3]：[描述和影响]

## 四、整改建议

### 紧急整改（不合规项）
1. [具体建议]
2. [具体建议]

### 建议改进（需优化项）
1. [具体建议]
2. [具体建议]

## 五、法规依据

- [法规名称] - [条款号]
- [法规名称] - [条款号]

---

**审核人：** PicoClaw 食品安全法律审核系统
**报告版本：** v1.0
```

## 特殊场景处理

### 进出口食品

- 出口食品需同时符合中国标准和目的国标准
- 进口食品需提供原产地证明、卫生证书
- 特殊膳食食品有额外要求

### 特殊食品

- 保健食品：需"蓝帽子"标志，有特定功能声称
- 特殊医学用途配方食品：需注册批准
- 婴幼儿配方食品：最严格的标准要求

### 网络销售食品

- 需公示食品经营许可证
- 网页信息需与标签一致
- 冷链食品有特殊要求

## 质量保证

- 每次审核都需引用具体法规条款
- 不确定的法规问题建议咨询专业法律顾问
- 法规更新时需及时更新参考文件
- 保留审核记录以备追溯

## 参考资料

详细法规和标准请查阅 `references/` 目录下的参考文件：
- `labeling-standards.md` - 食品标签标准详解
- `advertising-compliance.md` - 广告合规指南
- `food-additives.md` - 食品添加剂使用规范
- `import-export-regs.md` - 进出口食品法规
- `production-license.md` - 食品生产许可管理
- `key-regulations.md` - 核心法规条文摘要
