---
name: focus-deep-work
description: Maximize deep work with focus sessions, distraction logging, and productivity tracking
author: clawd-team
version: 1.0.0
triggers:
  - "deep work session"
  - "focus mode"
  - "start focus"
  - "distraction free"
  - "productivity session"
---

# Focus & Deep Work

Do your best work when distractions fade away.

## What it does

This skill turns your device into a focus machine. Start a deep work session and Clawd handles the rest: tracks your focus time, logs distractions as they arise (without breaking your flow), measures your productivity across sessions, and helps you optimize your environment for maximum concentration. Whether you're writing, coding, designing, or thinking hard—this skill removes friction and builds your deep work muscle.

**Key capabilities:**
- **Focus Sessions** - Timers based on proven productivity methods (Pomodoro, 52/17, 90-minute ultradian rhythms)
- **Distraction Logging** - Quick-capture logging when interruptions occur, with zero context switching
- **Deep Work Hours Tracking** - Weekly/monthly summaries of focused time by project or task
- **Environment Setup** - Automatic silencing, app blocking, and notification management (when permissions allow)

## Usage

### Start Session
Trigger: *"Start a 90-minute deep work session"* or *"Begin focus mode"*

Clawd launches a countdown timer, blocks distracting apps, and silences notifications. You work uninterrupted. Timer notifications appear at natural breakpoints (every 25 min for Pomodoro, or at session end for longer blocks).

### Log Distraction
Trigger: *"I got distracted"* or *"Log distraction: Slack notification"*

Quick-capture the distraction type without stopping the timer. Clawd records it with timestamp and category (internal/external). Build awareness of your distraction patterns over time.

### End Session
Trigger: *"End session"* or *"Stop focus"*

Clawd records total focus time, distractions during the session, and saves a session summary. You can reflect on what worked and what didn't.

### Check Stats
Trigger: *"Show my focus stats"* or *"Deep work summary this week"*

View total focus hours, distraction breakdown by category, average session length, and productivity trends. See which times of day you focus best.

### Set Environment
Trigger: *"Minimize distractions"* or *"Lock me in"*

Clawd can: mute system notifications, close or minimize specified apps, dim screen brightness, enable do-not-disturb mode, block website access (if permission granted), or play focus music.

## Session Types

- **Pomodoro (25 min)** - Classic timer for rapid-iteration work. Pairs with automatic breaks.
- **Ultradian (52 min)** - 52 minutes focus + 17-minute break. Aligns with natural energy cycles.
- **Deep Block (90 min)** - For complex thinking. One full cycle without interruption.
- **Custom** - Set your own timer. *"Start a 45-minute focus session"*

## Tips

1. **Start small.** New to deep work? Begin with 25-minute Pomodoros. Build the habit before extending sessions.

2. **Log early.** When a distraction hits, log it immediately—even mid-task. The friction of a quick log actually breaks the distraction's grip faster than ignoring it.

3. **Review your patterns.** Check stats weekly. You'll spot which environments, times, and tasks trigger your biggest distractions. Optimize accordingly.

4. **Use session types strategically.** Complex coding? 90 minutes. Administrative tasks? Pomodoro. Writing? 52 min. Match method to work.

5. **All data stays local on your machine.** Your focus logs, session history, and productivity patterns are never sent to servers. Your deep work habits remain yours alone.
