# Guia de Prompts: Template Baseado no Caso Brand_X

Este documento serve como um **template reutilizável** que orienta a IA (e o usuário) sobre quais perguntas fazer e como estruturar prompts estratégicos para projetos de branding, usando o caso Brand_X como modelo de excelência.

## Como Usar Este Guia

1. Ao iniciar um novo projeto de branding, a IA deve **replicar a mesma estrutura de perguntas** usada no caso Brand_X.
2. Este guia NÃO é sobre a marca Brand_X em si, mas sobre o **processo** que gerou a estratégia da Brand_X.
3. A IA deve adaptar as perguntas ao contexto do novo cliente, mantendo a profundidade analítica.

---

## Estrutura de Perguntas Estratégicas (Baseada em RACE)

### 1. Role (Papel da IA)
**Pergunta-Guia:** "Que tipo de expertise estratégica este projeto exige?"

**Template de Resposta:**
> "Você é um [TIPO DE ESPECIALISTA] com expertise em [ÁREA DE CONHECIMENTO ESPECÍFICA] e desenvolvimento de [OBJETIVO ESTRATÉGICO] para marcas de [CATEGORIA] que [DESAFIO ÚNICO]."

**Exemplo (Brand_X):**
> "Você é um consultor estratégico de branding com expertise em análise de dados qualitativos de clientes e desenvolvimento de posicionamento competitivo para marcas de consumo que reposicionam categorias saturadas através da simplicidade estratégica."

---

### 2. Action (Ações Priorizadas)
**Perguntas-Guia:**
- "Quais são as entregas esperadas deste projeto, na ordem de prioridade?"
- "Que tipo de análise precisa ser feita ANTES da criação?"

**Template de Resposta:**
> Analisar [MATERIAL DE INPUT] para desenvolver, nesta ordem de prioridade:
> 1. [ANÁLISE COMPETITIVA/INSIGHTS]
> 2. [POSICIONAMENTO DIFERENCIADO]
> 3. [PERSONALIDADE E TOM DE VOZ]
> 4. [DIRETRIZES DE IDENTIDADE]
> 5. [ESTRATÉGIA DE COMUNICAÇÃO]
> 
> Todos os outputs devem ser integrados em [FORMATO FINAL].

**Exemplo (Brand_X):**
> Analisar as transcrições do briefing, plataforma de marca e materiais complementares para desenvolver, nesta ordem de prioridade:
> 1. Análise de insights estratégicos com identificação de tensões competitivas
> 2. Proposta de posicionamento diferenciado versus concorrentes estabelecidos
> 3. Direcionamento para personalidade de marca com tom de voz específico
> 4. Recomendações para identidade visual e verbal com exemplos aplicados
> 5. Estratégia de comunicação para reposicionamento de categoria

---

### 3. Context (Contexto Estratégico Profundo)

#### 3.1 Perguntas sobre o Negócio
- "Qual o produto/serviço central da marca?"
- "Como o produto organiza ou simplifica a vida do consumidor?"
- "Qual é o 'job to be done' (trabalho contratado)?"

#### 3.2 Perguntas sobre Competição
- "Contra qual mindset ou lógica de mercado a marca compete?"
- "Quem são os concorrentes diretos? E os indiretos (que perpetuam a mesma mentalidade)?"
- "Que território estratégico a marca pode ocupar que está vago?"

#### 3.3 Perguntas sobre Público
- "Quem abandonou a categoria por achar complicado/caro/inacessível?"
- "Qual a faixa etária, perfil comportamental e valores desse público?"
- "O que esse público valoriza (praticidade, autenticidade, status)?"

**Template de Resposta (Context):**
> O cliente é a [NOME DA MARCA], [TIPO DE MARCA] que [PROPOSTA DE VALOR ÚNICA]. A marca compete diretamente contra [MINDSET DOMINANTE] perpetuado por [CONCORRENTES ESTABELECIDOS], e contra [ESTÉTICA/ABORDAGEM] de marcas como [OUTROS CONCORRENTES].
> 
> É uma resposta ao [FRUSTRAÇÃO DO MERCADO], criando o território do "[TERRITÓRIO NOVO - usar aspas]". Combina [ATRIBUTO 1] com [ATRIBUTO 2] e [ATRIBUTO 3], rejeitando conscientemente [O QUE NÃO FAZ].
> 
> O DNA da marca gira em torno de [PROPÓSITO EMOCIONAL]. O job to be done: [BENEFÍCIO FUNCIONAL CLARO]. Seu público são [PERFIL DEMOGRÁFICO] que [COMPORTAMENTO/ATITUDE]. São [TIPO DE PESSOA] que buscam [VALOR PRINCIPAL] sem abrir mão de [VALOR SECUNDÁRIO].

**Exemplo (Brand_X):**
> O cliente é a Brand_X, marca brasileira de skincare que organiza a rotina em três produtos vinculados aos momentos do dia: Haru (manhã), Nami (tarde) e Yoru (noite). A marca compete diretamente contra o mindset de que "skincare eficaz precisa ser complexo" perpetuado por gigantes como La Roche-Posay, Vichy e The Ordinary, e contra a estética clean aspiracional de marcas como Sallve e Care Natural Beauty.
> 
> É uma resposta ao cansaço gerado pela indústria que lucra com a complexidade, criando o território do "cuidado organizado pelo tempo, não por categorias". Combina eficácia técnica com estética zen e linguagem acessível, rejeitando conscientemente tanto o excesso de etapas quanto o vocabulário científico intimidador. O DNA da marca gira em torno de devolver simplicidade para quem abandonou skincare por achar complicado demais. O job to be done: permitir que pessoas cuidem da pele sem precisar pesquisar, estudar ou montar rotinas - apenas seguir o relógio. Seu público são urbanos entre 20 e 35 anos que desistiram de rotinas elaboradas porque não têm tempo, paciência ou interesse em virar especialistas. São profissionais que buscam praticidade sem abrir mão de qualidade, valorizando produtos que se encaixam naturalmente no ritmo do dia e no clima brasileiro.

---

### 4. Example (Restrições de Estilo e Formato)

#### 4.1 Perguntas sobre Tom de Escrita
- "A escrita deve ser formal, casual ou híbrida?"
- "Pode usar termos técnicos? Em que casos?"
- "Existem palavras ou estruturas proibidas (ex: 'inovador', 'solução única')?"

#### 4.2 Perguntas sobre Formato
- "Qual o formato de capitalização esperado (Sentence Case, Title Case)?"
- "Como evitar que o texto pareça 'marketing genérico de IA'?"

**Template de Resposta (Example):**
> Elabore textos com escrita [ESTILO - ex: criativa mas estratégica]. A escrita deve ser [TOM - ex: direta, mas nunca informal demais]. Pode usar [TIPO DE LINGUAGEM PERMITIDA] apenas quando [CONDIÇÃO].
> 
> Todos os textos precisam respeitar [REGRA DE FORMATAÇÃO]. Exemplo incorreto: [EXEMPLO ERRADO]. Exemplo correto: [EXEMPLO CORRETO].
> 
> **Restrições:**
> * Evite [VÍCIO 1 - ex: adjetivos em sequência]
> * Priorize [BOA PRÁTICA 1 - ex: frases naturais e variadas]
> * Quando [SITUAÇÃO], [AÇÃO RECOMENDADA]
> * Prefira [PRINCÍPIO - ex: clareza e fluidez] em vez de [ANTI-PADRÃO - ex: exagero descritivo]
> * Adapte [VARIÁVEL - ex: o tom] conforme [CONTEXTO], mantendo [CONSTANTE - ex: consistência com a identidade da marca]

**Exemplo (Brand_X):**
> Elabore textos com escrita criativa mas estratégica. A escrita deve ser direta, mas nunca informal demais. Pode usar termos técnicos de skincare apenas quando essenciais e sempre com clareza.
> 
> Todos os textos precisam respeitar a escrita tradicional, onde a primeira letra de cada frase está em maiúscula, exceto para nomes próprios, que deverão ser escritos sempre com início maiúsculo. Exemplo incorreto: Como A Marca Se Comporta e Fala. Exemplo correto: Como a marca se comporta e fala.
> 
> * Evite vícios de linguagem, especialmente o uso de adjetivos em sequência ou construções redundantes (ex.: "colorida e luminosa", "calmo e tranquilo"). Prefira precisão e economia de palavras.
> * Priorize frases naturais e variadas. Não reutilize estruturas, expressões ou aberturas de texto de forma recorrente entre conteúdos diferentes.
> * Quando abordar o mesmo tema, explore ângulos, ritmos e construções distintas, evitando que os textos soem repetitivos ou padronizados.
> * Prefira clareza e fluidez em vez de exagero descritivo. Cada palavra deve ter função clara no texto.
> * Adapte o tom conforme o contexto, mantendo consistência com a identidade da marca, mas sem engessar a linguagem.

---

## Checklist de Validação

Antes de gerar qualquer estratégia, a IA deve ter respostas claras para:

- [ ] Quem é a persona do especialista (Role)?
- [ ] Quais as 5 entregas prioritárias (Action)?
- [ ] Qual o território competitivo único da marca (Context)?
- [ ] Contra qual mindset a marca compete (Context)?
- [ ] Quem desistiu da categoria e por quê (Context)?
- [ ] Quais palavras/estruturas estão proibidas (Example)?
- [ ] Qual o formato de capitalização esperado (Example)?

Se qualquer resposta estiver vaga ou genérica, **a IA deve fazer perguntas de clarificação antes de prosseguir**.
