# App Store Review Safety Checklist (Practical)

Use this checklist to reduce rejection risk for utility apps.

## 1) Category & Positioning

- Avoid heavily saturated clones (flashlight, generic wallpaper, trivial quote apps).
- Use clear, specific utility value with realistic scope.
- Avoid misleading “AI magic” promises without concrete behavior.

## 2) Permissions

- Camera/photo permissions must be user-triggered and feature-bound.
- Explain why each permission is needed in plain language.
- Provide in-app alternatives where possible (e.g., import without camera).

## 3) Privacy and Data

- State local-first/offline-first architecture if no backend exists.
- Explicitly describe what is (and is not) uploaded.
- Include deletion/reset path for local user content.

## 4) Claims & Compliance

- Avoid guaranteed outcomes (health, legal, finance, earnings).
- Avoid prohibited or sensitive misuse scenarios.
- Keep marketing and feature copy factual and testable.

## 5) UX Completeness for v1

- No TODO/TBD labels in user-facing content.
- Empty states and error states are documented.
- Accessibility basics are covered (dynamic type, contrast, labels).
