---
name: fluora-setup
description: Interactive setup wizard for Fluora marketplace integration. Clones fluora-mcp from GitHub, builds locally, generates wallet, and configures mcporter.
homepage: https://fluora.ai
metadata:
  {
    "openclaw":
      {
        "emoji": "🔧",
        "requires": { "bins": ["node", "npm", "git"] },
      },
  }
---

# Fluora Setup - Interactive Onboarding Wizard (GitHub Version)

Complete setup wizard for accessing the Fluora marketplace. Uses the official GitHub repository for the latest working version.

## What This Skill Does

Automates the entire Fluora setup process:
1. ✅ Clones `fluora-mcp` from GitHub (https://github.com/fluora-ai/fluora-mcp)
2. ✅ Installs dependencies and builds locally
3. ✅ Generates wallet (auto-creates `~/.fluora/wallets.json`)
4. ✅ Extracts wallet address from private key
5. ✅ Displays funding instructions
6. ✅ Configures mcporter with local Fluora registry
7. ✅ Verifies setup is working

## Prerequisites

- Node.js 18+
- npm
- git
- mcporter installed (optional, will guide if missing)

## Usage

### From OpenClaw Agent

```typescript
// Run interactive setup
await setupFluora();

// With options
await setupFluora({
  skipMcporterConfig: false,
  fundingAmount: 10 // in USDC
});
```

### Direct Script Usage

```bash
# Interactive setup (recommended)
node setup.js

# Skip mcporter config
node setup.js --skip-mcporter

# Custom funding amount
node setup.js --funding 10
```

## What Gets Created/Modified

### 1. Local fluora-mcp Repository
```
~/.openclaw/workspace/fluora-mcp/
```

Cloned from GitHub and built locally with all dependencies.

### 2. Wallet File
```
~/.fluora/wallets.json
```

Auto-generated on first run with structure:
```json
{
  "BASE_MAINNET": {
    "privateKey": "0x..."
  }
}
```

### 3. mcporter Config
```
~/.openclaw/workspace/config/mcporter.json
```
(or `~/.mcporter/mcporter.json` if workspace config doesn't exist)

Adds Fluora registry pointing to local build:
```json
{
  "mcpServers": {
    "fluora-registry": {
      "command": "node",
      "args": ["/Users/YOUR_USERNAME/.openclaw/workspace/fluora-mcp/build/index.js"],
      "env": {
        "ENABLE_REQUEST_ELICITATION": "true",
        "ELICITATION_THRESHOLD": "0.01"
      }
    }
  }
}
```

**Note:** Uses the LOCAL GitHub build, not `npx fluora-mcp` from npm, because the npm version has a parameter parsing bug.

## Wallet Funding

The skill will display your wallet address and instructions:

```
Your Fluora Wallet Address:
0x1234567890abcdef1234567890abcdef12345678

To fund your wallet:
1. Open Coinbase, Binance, or your preferred exchange
2. Send $5-10 USDC to the address above
3. **Important:** Select "Base" network (NOT Ethereum mainnet)
4. Wait ~1 minute for confirmation
```

### Network Details
- **Network:** Base (Coinbase L2)
- **Token needed:** USDC only (for service payments, $5-10 recommended)
- **Payments:** Handled automatically with USDC, no additional tokens needed

### Where to Get USDC on Base

**From an exchange:**
- Coinbase: Withdraw USDC → Select "Base" network
- Binance: Withdraw USDC → Select "Base" network
- OKX: Similar process

**Bridge from Ethereum:**
- https://bridge.base.org
- Transfer USDC from Ethereum → Base

**Buy directly on Base:**
- Use Coinbase Wallet or Rainbow Wallet
- Buy USDC directly on Base

## Verification

The skill automatically verifies:
- ✅ fluora-mcp cloned from GitHub
- ✅ Dependencies installed
- ✅ Build successful
- ✅ Wallet file exists
- ✅ Private key is valid
- ✅ Wallet address derived correctly
- ✅ mcporter config is valid JSON
- ✅ Fluora registry configured with local path

Optional: Check wallet balance (after funding)

## Return Value

```json
{
  "success": true,
  "walletAddress": "0x...",
  "privateKeyPath": "~/.fluora/wallets.json",
  "fluoraPath": "~/.openclaw/workspace/fluora-mcp",
  "mcporterConfigured": true,
  "funded": false,
  "nextSteps": [
    "Fund wallet with $1 USDC on Base",
    "Test with: mcporter call fluora-registry.exploreServices",
    "Start building with workflow-to-monetized-mcp"
  ]
}
```

## After Setup

### Test Your Setup

```bash
# List available services
mcporter call 'fluora-registry.exploreServices()'

# Use a free service (testnet screenshot)
mcporter call 'fluora-registry.useService' --args '{
  "serviceId": "zyte-screenshot",
  "serverUrl": "https://pi5fcuvxfb.us-west-2.awsapprunner.com",
  "serverId": "c2b7baa1-771c-4662-8be4-4fd676168ad6",
  "params": {"url": "https://example.com"}
}'

# Use a paid service (PDF conversion - requires confirmation)
mcporter call 'fluora-registry.useService' --args '{
  "serviceId": "pdfshift-convert",
  "serverUrl": "https://9krswmmx4a.us-west-2.awsapprunner.com",
  "serverId": "c45d3968-0aa1-4d78-a16e-041372110f23",
  "params": {"websiteUrl": "https://example.com"}
}'
```

### Start Building

Now you can use the other Fluora skills:
1. **workflow-to-monetized-mcp** - Generate your own service
2. **railway-deploy** - Deploy to Railway
3. **fluora-publish** - List on marketplace

## Troubleshooting

### "git clone failed"
Ensure you have git installed and internet access.

### "npm install failed"
Check Node.js version (18+) and npm is working.

### "Build failed"
Check the error in the build output. Usually dependency issues.

### "wallets.json not created"
Run the local fluora-mcp once manually:
```bash
cd ~/.openclaw/workspace/fluora-mcp
node build/index.js
# Press Ctrl+C after it starts
```

### "Invalid private key"
The key in `~/.fluora/wallets.json` should be 0x-prefixed hex string (66 characters).

### "Wrong network"
Make sure you're sending USDC on **Base** network, not Ethereum mainnet or other L2s.

### "Still no balance after funding"
- Check transaction on Base block explorer: https://basescan.org
- Wait 1-2 minutes for confirmation
- Verify you sent to the correct address
- Ensure you selected Base network (not Ethereum)

## Why GitHub Instead of npm?

The npm package (`fluora-mcp@0.1.38`) has a parameter parsing bug where `useService` cannot receive parameters correctly. The GitHub repository (v0.1.39+) has the fix.

**Bug details:**
- npm version: Schema definition uses plain object, breaking MCP parameter passing
- GitHub version: Fixed schema definition, all parameters work correctly

## Security Notes

### Private Key Safety
- `~/.fluora/wallets.json` contains your private key
- Keep this file secure (default permissions: 600)
- Never commit to git
- Never share the private key
- This wallet is for **buying services**, not storing large amounts

### Best Practices
- Fund with small amounts initially $1 USDC
- Rotate wallets if compromised
- Use separate wallet for each OpenClaw instance

## Cost Summary

### Setup Costs
- fluora-mcp clone: Free
- Initial funding: $1 USDC

### Ongoing Costs
- Service calls: $0.001-0.20 per call (varies by service)
- Payments: Handled automatically with USDC, no additional fees. Gas fees are covered by the seller

### Example Usage
- $5 USDC → ~250-5000 calls (depending on service)
- Most calls are $0.001-0.02

## Resources

- Fluora marketplace: https://fluora.ai
- GitHub repo: https://github.com/fluora-ai/fluora-mcp
- Base network: https://base.org
- Block explorer: https://basescan.org
- USDC info: https://www.circle.com/en/usdc
