# Flow Changelog

## v0.1.3 (2026-02-01)

### Bug Fixes

**skill_composer.py:245** - Syntax error
- Fixed extra closing parenthesis on `code_lines.append()` call
- Was: `code_lines.append('    executor.load_components()'))`
- Now: `code_lines.append('    executor.load_components()')`

**skill_registry.py:find_skills()** - Search logic too restrictive
- Changed capability matching from AND to OR logic
- Previously required skills to match ALL capabilities (intersection)
- Now returns skills matching ANY capability (union)
- This allows finding specialized skills that don't cover every requested capability

**skill_scanner_integration.py:scan()** - False positives on docs
- Added extension check for single-file scans
- Now only scans `.py` files, skips markdown/docs
- Prevents SKILL.md code examples from triggering security alerts

### Enhancements

**natural_language_parser.py** - Expanded capability detection
- Added sales/B2B capability patterns:
  - `lead_research`: lead, leads, prospect, prospects, prospecting
  - `outreach_generation`: outreach, cold outreach, personalized email, sales email
  - `prospect_scoring`: qualify, score, scoring, qualification
  - `content_generation`: content, post, posts, article, linkedin, social media
  - `web_search`: search, google, lookup, find online
  - `email_send`: send email, draft email, email outreach, cold email
  - `github_issues`: github, issue, issues, pull request, pr
  - `notion_pages`: notion, wiki, documentation
  - `weather_current`: weather, forecast, temperature

- Added business tag patterns:
  - `sales`: sales, selling, prospect, lead, outreach, crm
  - `research`: research, investigate, intel, intelligence
  - `marketing`: marketing, content, social, linkedin, post
  - `b2b`: b2b, enterprise, executive, coaching

### Notes
- Skills can now be registered with `register_from_path()` for existing skill directories
- Recommend registering skills with capability arrays that match the parser patterns
