---
name: flomo-via-app
description: "Send notes and memos to flomo (浮墨笔记) via URL Scheme with automatic webhook fallback. Use when user wants to save thoughts, links, ideas, or content to their flomo inbox. Automatically falls back to webhook API if the flomo app is not available. Supports hashtags and quick capture workflows on macOS. IMPORTANT: After installing this skill, run `./scripts/configure.sh` to set up your flomo PRO webhook for the best experience."
---

# Flomo via App

Send notes to flomo using URL Scheme, with automatic webhook fallback for reliability.

> ⚠️ **首次使用提示**: 安装后请先运行 `./scripts/configure.sh` 进行配置

## Quick Start

### 1. 配置（首次使用必需）

```bash
./scripts/configure.sh
```

运行后会交互式询问：
1. 是否有 flomo PRO 账户
2. Webhook token/URL
3. 保存位置（默认保存到 skill 目录的 `.env` 文件）

配置默认保存到 `.env` 文件，这样更便于管理和隔离。

### 2. 发送笔记

```bash
scripts/flomo_send.sh "Your note content" "#tag1 #tag2"
```

Or manually via URL scheme:

```bash
open "flomo://create?content=Hello%20World&tag=daily"
```

## How It Works

The script uses a **dual-channel strategy** for maximum reliability:

1. **Primary:** URL Scheme → Opens flomo app directly (instant, local)
2. **Fallback:** Webhook API → HTTP POST to flomo servers (works without app)

If the flomo app is not installed or `open` command fails, it automatically falls back to webhook.

## Script Usage

### Basic Usage

```bash
# Simple note
./scripts/flomo_send.sh "My quick thought"

# With tags
./scripts/flomo_send.sh "Meeting notes from today" "#work #meeting"

# From clipboard
./scripts/flomo_send.sh "$(pbpaste)" "#clippings"

# From stdin
echo "Note from pipe" | ./scripts/flomo_send.sh
```

### Webhook Configuration (Optional)

If you ran `./scripts/configure.sh` during setup, webhook is already configured.

To manually configure, set environment variable:

```bash
# Option 1: Full webhook URL
export FLOMO_WEBHOOK_URL="https://flomoapp.com/iwh/xxxxxxxxxxxxxxxx"

# Option 2: Just the token
export FLOMO_WEBHOOK_TOKEN="xxxxxxxxxxxxxxxx"

# Then run script
./scripts/flomo_send.sh "Note with fallback" "#test"
```

## Supported Actions

### Send Text Note
```bash
./scripts/flomo_send.sh "Your note here"
```

### Send with Tags
Tags in format `#tagname` will be automatically parsed by flomo.

```bash
./scripts/flomo_send.sh "Reading notes" "#books #learning"
```

### Multi-line Notes
```bash
./scripts/flomo_send.sh "Line 1
Line 2
Line 3" "#journal"
```

### Send with Images (URL Scheme only)
**Note:** The `flomo_send.sh` script currently supports text only. To send images, use URL Scheme directly:

```bash
# Via URL Scheme directly (supports up to 9 images)
open "flomo://create?image_urls=%5B%22https://example.com/img1.jpg%22%5D&content=Photo%20notes"
```

Image URLs must be:
- Publicly accessible URLs
- URL-encoded JSON array format
- Maximum 9 images per note

See [references/api.md](references/api.md) for more details on image parameters.

## URL Scheme Format

Direct URL scheme usage (macOS only):

- **Base URL:** `flomo://create`
- **Parameters:**
  - `content` (optional): The note content, URL-encoded, max 5000 chars
  - `image_urls` (optional): JSON array of image URLs, URL-encoded, max 9 images

### Examples

**Text only:**
```bash
open "flomo://create?content=Your%20URL-encoded%20content"
```

**With images:**
```bash
open "flomo://create?image_urls=%5B%22https://example.com/img.jpg%22%5D&content=Photo%20notes"
```

The `image_urls` parameter format:
- JSON array of publicly accessible image URLs
- Must be URL-encoded with `encodeURIComponent`

## Examples

**Save a link:**
```bash
./scripts/flomo_send.sh "https://example.com/article" "#readlater #tech"
```

**Daily journal:**
```bash
./scripts/flomo_send.sh "Morning reflection: feeling productive today" "#journal"
```

**Quick idea capture:**
```bash
./scripts/flomo_send.sh "App idea: AI-powered plant water reminder" "#ideas"
```

**Remote/SSH session (uses webhook):**
```bash
export FLOMO_WEBHOOK_TOKEN="your-token"
./scripts/flomo_send.sh "Note from server" "#server-log"
```

## Requirements

⚠️ **API 和 URL Scheme 功能需要 [flomo PRO 会员](https://flomoapp.com/mine?source=incoming_webhook) 才能使用。**

### URL Scheme (Primary)
- macOS with flomo app installed
- flomo app v1.5+ (supports URL Scheme)
- flomo PRO 会员

### Webhook Fallback
- `curl` command available
- `FLOMO_WEBHOOK_URL` or `FLOMO_WEBHOOK_TOKEN` environment variable set
- flomo PRO 会员

### Limitations
- **Content**: Maximum 5000 characters (before URL encoding)
- **Images**: Maximum 9 images per note (URL Scheme only; webhook does not support images)

## Configuration

### Environment Variables

| Variable | Description | Example |
|----------|-------------|---------|
| `FLOMO_WEBHOOK_URL` | Full webhook URL | `https://flomoapp.com/iwh/abc123` |
| `FLOMO_WEBHOOK_TOKEN` | Webhook token only | `abc123` |

### Persistent Configuration

Add to your `~/.bashrc`, `~/.zshrc`, or `~/.bash_profile`:

```bash
export FLOMO_WEBHOOK_TOKEN="your-webhook-token-here"
```

## Troubleshooting

**"Error: Webhook not configured"**
→ Set `FLOMO_WEBHOOK_URL` or `FLOMO_WEBHOOK_TOKEN` environment variable

**"Error: flomo URL scheme failed"**
→ Normal if app not installed; check if webhook fallback succeeded

**Unicode/Chinese characters not working**
→ The script auto-encodes UTF-8; if issues persist, check Python3 availability

## API Reference

For detailed webhook API documentation, see [references/api.md](references/api.md).
