---
name: flomo-notes
description: Save notes to Flomo via the Flomo inbox webhook. Use when the user says "save to flomo", "记录到 flomo", "flomo note", or asks to store a note in flomo.
---

# flomo-notes

Save notes to [Flomo](https://flomoapp.com/) using a single webhook POST.

## Setup

Provide your Flomo inbox webhook URL via environment variable:

- `FLOMO_WEBHOOK_URL` (required), example:
  `https://flomoapp.com/iwh/XXXXXXXX`

You can set it either:

1) In `~/.openclaw/openclaw.json` (recommended):

```json5
{
  skills: {
    entries: {
      "flomo-notes": {
        env: {
          FLOMO_WEBHOOK_URL: "https://flomoapp.com/iwh/XXXXXXXX"
        }
      }
    }
  }
}
```

2) Or in your shell/service environment:

```bash
export FLOMO_WEBHOOK_URL="https://flomoapp.com/iwh/XXXXXXXX"
```

## How the skill works

When triggered, run:

```bash
bash scripts/save_to_flomo.sh "<note text>"
```

## Example prompts (to trigger)

- `save to flomo: buy milk, eggs`
- `记录到 flomo：下周美股大事件...`

## Script manual test

```bash
FLOMO_WEBHOOK_URL="https://flomoapp.com/iwh/XXXXXXXX" \
  bash scripts/save_to_flomo.sh "hello from openclaw"
```

## Security

Treat the webhook URL like a secret: anyone with it can post into your Flomo inbox.
