# Price Tracking & Alerts

## Price Alert Strategy
- Set alerts on flexible dates, not just exact dates
- Threshold alerts: notify only when price drops below target (e.g., "MAD→JFK <€400")
- Track historical averages — know if current price is high/low for route
- Book when price is 10-20% below historical average

## When to Book
- Domestic US: 1-3 months ahead, sweet spot ~6 weeks
- International: 2-4 months ahead, sweet spot ~8 weeks
- Peak seasons (Christmas, summer): book 3-6 months ahead
- Error fares: book immediately, ask questions later (refundable if mistake)

## Price Prediction Limitations
- No reliable "will prices go up/down" prediction exists publicly
- Hopper predictions: directional only, not precise
- Google Flights trends: shows historical patterns, not future guarantees
- Best strategy: set target price, book when hit, stop checking

## Flight Status Tracking
- Monitor starting T-24h for delays/cancellations
- Use FlightAware or FlightRadar24 for real-time tracking
- Inbound aircraft delays predict your flight's delay
- Gate changes: common, check 2h before departure

## Automated Actions
- Price drop → notify immediately with booking link
- Flight delay >1h → search alternative routing
- Cancellation → immediately search rebooking options
- Schedule change → verify connections still work
