# Flight Booking & Management

## Booking Best Practices
- Book all passengers on same PNR for group handling during disruptions
- Pre-select seats at booking — don't rely on check-in lottery
- Add frequent flyer numbers at booking, not later
- Screenshot/save confirmation immediately — airline systems can glitch

## Flexibility & Protection
- Flexible fares worth it for trips >30 days out or during illness season
- Basic economy: no changes, no refunds, last to board, middle seats
- Travel insurance: verify it covers the specific destination and activities
- Credit card travel protection: check if booking on that card activates coverage

## Disruption Handling
- Track flight status from T-24h — delays often predictable
- Rebook proactively when connection becomes risky (<60min remaining)
- Know your rights: EU261 (delays >3h = compensation), DOT rules (US)
- During IRROPS: call airline while also waiting in line — race condition
- Hotel/meal vouchers: ask explicitly, airlines don't volunteer

## Multi-Passenger Bookings
- Families: ensure all on same reservation for rebooking priority
- Seat selection: book early for adjacent seats, especially on full flights
- Special requests (meals, wheelchair, bassinet): add at booking, reconfirm 24h before

## Documentation
- Passport validity: 6 months beyond travel date for most countries
- Visa requirements: check BEFORE booking, especially transit visas
- ESTA/ETA: apply 72h minimum before travel
- Onward ticket requirement: some countries enforce strictly (SE Asia, South America)
