#!/bin/bash
set -e

echo "✈️  Installing flight-search..."

if command -v uv &>/dev/null; then
  echo "Using uv..."
  uv tool install flight-search
elif command -v pipx &>/dev/null; then
  echo "Using pipx..."
  pipx install flight-search
elif command -v pip3 &>/dev/null; then
  echo "Using pip3..."
  pip3 install --user flight-search
elif command -v pip &>/dev/null; then
  echo "Using pip..."
  pip install --user flight-search
else
  echo "❌ No Python package manager found (uv, pipx, or pip)"
  echo "Install uv: curl -LsSf https://astral.sh/uv/install.sh | sh"
  exit 1
fi

echo ""
echo "✅ flight-search installed!"
echo ""
echo "Try it:"
echo "  flight-search DEN LAX --date 2025-03-01"
