---
name: flatnotes-tasksmd-github-audit
description: "Thoroughly audit Tasks.md + Flatnotes for drift and accuracy; use GitHub (gh CLI) as source of truth to detect stale notes/cards and missing links. Produces a report and an optional fix plan."
---

# Flatnotes + Tasks.md + GitHub Audit

Use this skill when Brandon asks to **audit** the Flatnotes/Tasks.md system for accuracy and ensure it’s **up to date**, using **GitHub as the source of truth**.

## Quick start
Run the bundled auditor (report-only):

```bash
node skills/flatnotes-tasksmd-github-audit/scripts/audit.mjs --since-days 30 --write
```

Outputs:
- Markdown report: `tmp/flatnotes-tasksmd-audit.md`
- JSON report: `tmp/flatnotes-tasksmd-audit.json`

> If `gh` is not authenticated, the audit still runs but GitHub checks will be marked as `SKIPPED_GITHUB`.

---

## Data sources (defaults)
- Tasks.md root: `/home/ds/.config/appdata/tasksmd/tasks`
- Flatnotes root: `/home/ds/.config/appdata/flatnotes/data`
- Flatnotes “system notes” mirror in workspace: `notes/resources/flatnotes-system/`

Override via env vars:
- `TASKS_ROOT`
- `FLATNOTES_ROOT`

---

## Audit goals (what “accurate” means)

### A) Board hygiene (Tasks.md)
- Global lanes exist: `00 Inbox`, `05 Backlog`, `10 Next`, `20 Doing`, `30 Blocked`, `40 Waiting`, `90 Done`.
- **Lane rule preference:** `prio-p2` lives in `05 Backlog` by default (no `prio-p2` in `10 Next`).
- Doing WIP ≤ 3 (preference).
- Cards should be consistently formatted (Outcome/Steps) and tagged (proj/prio/eff/type).
- Blocked cards include `Unblock:`.
- Project cards include a Flatnotes pointer (`Flatnotes: ...`).

### B) Project completeness (Flatnotes)
For each active project in `SYS Workspace - Project Registry`:
- Required project notes exist:
  - `PJT <slug> - 00 Overview`
  - `PJT <slug> - 10 Research`
  - `PJT <slug> - 20 Plan`
  - `PJT <slug> - 90 Log`
- Hub note has:
  - Current status (1–3 bullets)
  - Links section with repo + Tasks filter
  - Decisions section linking relevant ADR(s)

### C) GitHub truth reconciliation (GitHub = source of truth)
For each project repo in the registry:
- Open PRs should have a corresponding Tasks card (Doing/Next/Blocked/Waiting) OR an explicit reason why not.
- Recently merged PRs should be reflected somewhere:
  - preferably a short note in the project log (`PJT <slug> - 90 Log`) + hub status update, or
  - a Done card with PR link.
  - (Audit treats either as reconciled; it may warn if a merged PR is only on a Done card but missing from the log.)
- Done cards should ideally include a PR link when work was shipped via PR.

---

## Workflow (recommended)
1) **Parse registry**
   - Read `SYS Workspace - Project Registry` from Flatnotes.
   - Extract: slug, status, Tasks tag, GitHub repo URL.

2) **Scan Tasks.md**
   - Index cards by lane and by `proj-*` tag.
   - Flag lane rule violations (`prio-p2` in Next, etc.).
   - Flag cards missing Flatnotes pointer.

3) **Scan Flatnotes**
   - Check required project notes exist.
   - Check hub Decisions section links ADR notes.

4) **GitHub cross-check**
   - Use `gh`:
     - `gh pr list --state open --json ...`
     - `gh pr list --state merged --search "merged:>=<date>" --json ...` (or equivalent)
   - Try to match PRs ↔ Tasks cards using:
     - PR URL in card content
     - PR number
     - Title substring heuristic

5) **Report**
   - Output: summary + per-project drift list + fix plan.

---

## Applying fixes (guardrails)
Default is **report-only**.

If Brandon explicitly asks to apply fixes:
- Safe auto-fixes allowed:
  - create missing Flatnotes notes (`10 Research`, etc.) using existing templates
  - add missing ADR links to hub Decisions section
  - move `prio-p2` from Next → Backlog
  - add missing Flatnotes pointers to Tasks cards
- Anything that renames files or deletes content: ask first.

---

## Bundled code
- `scripts/audit.mjs` — generates the report (Markdown + JSON). If needed, patch it rather than rewriting.
