# EchoDecks Skill

Integrates with the EchoDecks External API for flashcard management, AI generation, and audio study sessions.

## Configuration
Requires `ECHODECKS_API_KEY` environment variable.

## Tools

### `echodecks_get_user`
Get user profile, credits, and global study statistics.

### `echodecks_list_decks`
List all decks in your account.
- `id` (optional): Retrieve a specific deck by ID.

### `echodecks_create_deck`
Create a new flashcard deck.
- `title` (required): Name of the deck.
- `description` (optional): Brief description.

### `echodecks_list_cards`
List cards in a specific deck.
- `deck_id` (required): The ID of the target deck.

### `echodecks_generate_cards`
Generate new flashcards using AI.
- `deck_id` (required): The target deck ID.
- `topic` (optional): Topic string.
- `text` (optional): Detailed source text.
*Cost: 10 credits.*

### `echodecks_generate_podcast`
Synthesize an audio podcast from a deck.
- `deck_id` (required): The source deck ID.
- `style` (optional): "summary" or "conversation" (default: "summary").
*Cost: 50 credits.*

### `echodecks_podcast_status`
Check the progress of a generated podcast.
- `id` (required): The podcast ID.

### `echodecks_get_study_link`
Get a direct link to a web-based study session.
- `deck_id` (required): The deck to study.

### `echodecks_submit_review`
Submit a spaced-repetition review for a card.
- `card_id` (required): The ID of the card.
- `quality` (required): 0 (Again), 1 (Hard), 2 (Good), 3 (Easy).

## Implementation
All tools wrap the `scripts/echodecks_client.py` CLI.
