# Red Flags: Protecting Your Fiverr Account

## Buyer Red Flags (Decline or Proceed with Caution)

### Immediate Decline
| Signal | Why It's Dangerous |
|--------|-------------------|
| "Let's talk on WhatsApp/email first" | ToS violation trap, potential scam |
| "Send work, I'll pay after reviewing" | Will never pay |
| Account created same day + complex order | High chargeback risk |
| "I'll give 5 stars for extra free work" | Review manipulation |
| Requests your login credentials | Account theft |
| Vague requirements + tight deadline | Guaranteed scope creep |
| Asking for free "test" before order | Free work extraction |

### Proceed with Caution
| Signal | Mitigation |
|--------|------------|
| No profile picture or bio | Request detailed requirements upfront |
| First-time buyer | Clear milestones, frequent updates |
| Much lower budget than your rate | Politely decline or explain value |
| Requests unlimited revisions | Define revision limit in writing |
| Previous orders with many cancellations | Check if visible in reviews |

## Response Templates

### Off-Platform Request
> "Thanks for reaching out! I keep all communication on Fiverr to ensure we're both protected by their buyer/seller guarantees. Happy to discuss everything here—what questions can I answer about the project?"

### Free Test Request
> "I understand wanting to see my work style! Instead of a test, you can check my portfolio samples and reviews from past clients. For this specific project, I can offer a small paid trial order if you'd like to start with a limited scope."

### Scope Creep
> "Great idea! That would be outside the current order scope. I can add it for $[X]—want me to send a custom offer? Or we can include it in a follow-up order."

### Threatening Review
> "I want to make sure you're satisfied with your order. Let's focus on resolving your concerns within the project scope. If there's something specific I can adjust within our agreement, I'm happy to help. Fiverr's support team is also available if you'd like their assistance."

## Chargeback Prevention

1. **Document everything** in Fiverr messages (never external)
2. **Deliver through Fiverr's system** (use the Deliver button)
3. **Watermark previews** until final payment confirmed
4. **Screenshot requirements** discussed in chat
5. **For large orders**: Use milestones or multiple smaller orders

## ToS Violations to Avoid (Your Side)

| Action | Consequence |
|--------|-------------|
| Sharing contact info before order | Warning → ban |
| Accepting payment outside Fiverr | Permanent ban |
| Fake reviews (friends, purchased) | Permanent ban |
| Multiple accounts | Both accounts banned |
| Delivering via suspicious external links | Order cancelled, possible ban |
| Mentioning competitor platforms | Warning |
