# Getting Started on Fiverr: Zero to First $100

## Account Setup Checklist

- [ ] Professional profile photo (face visible, neutral background)
- [ ] Username: professional, memorable, no numbers if possible
- [ ] Bio: Problem you solve → Who you help → Why you (keep under 200 words)
- [ ] Skills: Add all relevant, be specific
- [ ] Languages: Mark fluency levels accurately
- [ ] Complete identity verification (speeds up first withdrawal)

## First Gig Creation

### Title Formula
`I will [specific deliverable] for [target audience]`

Examples:
- ❌ "I will do graphic design" (too vague)
- ✅ "I will design a modern logo for your startup"
- ✅ "I will write SEO blog posts for SaaS companies"

### Pricing for Zero Reviews
| Your Market Rate | Starter Price | When to Raise |
|------------------|---------------|---------------|
| $50+ | $15-25 | After 5 orders |
| $100+ | $25-40 | After 10 orders |
| $200+ | $40-75 | After 15-20 orders |

Build reviews first, then raise prices 10-20% every 5-10 successful orders.

### Package Structure
- **Basic**: Minimum viable deliverable. Entry price.
- **Standard**: What most clients actually need. Best value positioning.
- **Premium**: Full service + extras. Premium pricing.

Example (Logo Design):
- Basic ($25): 1 logo concept, PNG only
- Standard ($50): 3 concepts, vector files, 2 revisions
- Premium ($100): 5 concepts, full brand kit, unlimited revisions

## Getting First Orders

### Strategies That Work
1. **Buyer Requests / Get Briefs**: Apply to matching projects daily
2. **Competitive pricing**: Slightly below market to win early orders
3. **Fast response time**: Under 1 hour dramatically improves conversion
4. **Detailed gig description**: Answer every possible question
5. **Portfolio samples**: Even if personal projects, show your work

### Writing Proposals That Convert
- Reference something specific from their request
- Explain your approach briefly
- Include relevant sample if possible
- End with question (creates engagement)

Template:
> "Hi [name if visible]! I read that you need [specific thing]. I've done similar work for [type of client]—you can see an example [here/in my portfolio]. My approach would be [1-2 sentences]. A quick question: [relevant question about their project]?"

### What NOT to Do
- ❌ Copy-paste generic proposals
- ❌ Lowball so much you can't deliver quality
- ❌ Promise unrealistic timelines
- ❌ Buy fake reviews
- ❌ Ask friends to create accounts and order

## First 30 Days Roadmap

| Week | Goal | Focus |
|------|------|-------|
| 1 | Account + 1-2 gigs live | Perfect your profile, optimize gig |
| 2 | First order | Apply to 10+ buyer requests daily |
| 3 | 3-5 orders | Over-deliver, collect reviews |
| 4 | Raise prices 20% | Evaluate what's working |

## Common Newbie Mistakes

1. **Too many gigs at once**: Start with 1-2, perfect them
2. **Pricing too low**: $5 gigs attract worst clients
3. **Overpromising delivery time**: Add buffer for revisions
4. **Ignoring analytics**: Check which gigs get impressions
5. **Not asking for reviews**: Politely remind after successful delivery
