---
name: Fiverr
description: Build and scale a Fiverr freelancing business with gig optimization, buyer communication, and seller level progression.
---

## Context

Fiverr explicitly permits AI tools in all service categories. Disclosure required only when clients ask. Focus on adding human value to AI-assisted work.

## Gig Optimization

- **Title**: Include primary keyword + differentiator. Test variations monthly.
- **Packages**: Basic = entry point, Standard = most popular (price accordingly), Premium = upsell.
- **Tags**: Use all 5 slots. No overlap. Research competitor tags.
- **Description**: Problem → Solution → Why you → CTA. Include FAQ to reduce messages.
- **Images**: First image = thumbnail. Must work at small size. Video gigs convert 20%+ better.

## Buyer Communication

**Prioritize by type:**
- 🔥 Hot (specific project, budget mentioned) → respond in <1h
- 🟡 Warm (interested, needs info) → respond in <4h
- 🔵 FAQ (can template) → use saved responses
- 🚩 Red flag → see `red-flags.md`

**Scope creep defense**: "That's outside the original order. I can add it for $X—want me to send a custom offer?"

## Red Flags (Immediate Decline)

- Wants to move off-platform (WhatsApp, email) before order
- "Send work first, I'll pay after"
- Account created today + complex project
- Threatening review manipulation
- Requests login credentials

See `red-flags.md` for full patterns and response templates.

## Seller Levels

| Level | Requirements | Benefits |
|-------|--------------|----------|
| New | None | Standard features |
| Level 1 | 60 days, 10 orders, 4.7+ rating | Priority support |
| Level 2 | 120 days, 50 orders, 4.7+ rating | Eligibility for Promoted Gigs |
| Top Rated | 180 days, 100 orders, 4.7+ rating | 7-day clearance, VIP support |

**Metrics to protect**: Response rate (>90%), Order completion (>90%), On-time delivery (>90%)

## Beginners

First 10 orders are hardest. Strategy: competitive pricing → deliver exceptional → collect reviews → raise prices gradually. See `getting-started.md` for detailed roadmap.

## Scaling Operations

For 20+ simultaneous orders: unified tracking, template variations (never identical text), realistic response timing (no instant replies), VA handoff protocols. See `scaling.md` for workflows.

## Legal Notes

- Fiverr permits AI across all categories (unlike Upwork)
- Disclose AI use when asked—never deny
- You must own rights to deliverables (check your AI tool's ToS)
- EU clients: higher transparency expectations under AI Act

See `legal.md` for full compliance details.
