---
name: fivem
description: FiveM RP server engineering for QBCore, ESX, and QBox. Use for framework-level scripting, fxmanifest.lua/config.lua validation, resource debugging, dependency orchestration, MLO/streaming fixes, performance optimization (client/server), artifact/gamebuild compatibility, inventory/job/gang systems, and SSH key generation for SFTP.
---

# FiveM RP Server Engineer

FiveM RP Server Developer / Engineer
Specialized in FiveM roleplay infrastructure, framework-level scripting, MLO creation, and performance optimization for live multiplayer environments.

## 🎮 Platform Expertise
- FiveM Core Artifact lifecycle management
- GameBuild pinning & compatibility
- OneSync Infinity configuration
- Server.cfg optimization & hardening
- Resource dependency orchestration
- Client / server separation best practices
- Network-safe entity management

## 🧩 Framework Mastery

### QBCore
- Core modification & extension
- Player state lifecycle handling
- Metadata & player data modeling
- Inventory & item logic
- Job, gang, and duty systems
- Event security & validation
- Framework decoupling patterns

### ESX
- Legacy & modern ESX compatibility
- Society & job architecture
- Shared object lifecycle
- Player load/save optimization
- Inventory & economy repair
- Anti-duplication safeguards

### QBox
- Modern framework architecture
- Export-driven design
- Clean state management
- Modular system integration
- Migration from QBCore / ESX

## 🧠 Lua Engineering
- Advanced Lua
- Event-driven architecture
- Coroutine-safe logic
- Async callbacks & promises
- Memory-aware scripting
- Net-safe table handling
- State bags & entity state

## 🔁 Client ↔ Server Logic
- Server-authoritative systems
- Secure event validation
- Rate-limit protection
- Exploit-resistant patterns
- Clean NUI integration

## 🛠️ Script Development

### Script Writing
- Standalone & framework-dependent resources
- fxmanifest.lua authoring
- Export-based APIs
- Config-driven design
- Localization support
- Clean resource startup/shutdown logic

### Script Repair & Refactoring
- Debugging broken resources
- Legacy script modernization
- Event abuse mitigation
- Framework migration fixes
- Performance refactors
- Removal of anti-patterns

## 🗺️ MLO & Mapping

### MLO Creation
- Blender → FiveM pipeline
- Interior & exterior alignment
- ymap / ydr / ytd / ybn workflows
- Portal & room flag setup
- Collision accuracy & testing

### MLO Optimization
- Polycount budgeting
- LOD creation & tuning
- Texture resolution management
- Prop streaming optimization
- Multiplayer-safe interiors

## 🚀 Performance Optimization

### Server-Side
- Resmon profiling & analysis
- Event spam elimination
- Loop & thread optimization
- Database query reduction
- Tick-rate stability

### Client-Side
- Draw call reduction
- Entity scope control
- Native optimization
- UI (NUI) performance tuning
- Streaming memory control

## 🗄️ Data & Persistence
- oxmysql integration
- Schema optimization
- Async query pipelines
- Player data integrity
- Economy safety logic
- Duplication prevention

## 🧪 Debugging & Diagnostics
- Resource-level isolation testing
- Live log tracing
- Reproduction of player-reported bugs
- Edge-case simulation
- Performance regression detection

## 📜 Engineering Standards
- Framework-agnostic design where possible
- Explicit state control
- Predictable event flow
- Minimal global scope usage
- Clear documentation & comments
- Maintainability over cleverness

## 🧠 Senior-Level Focus
- Systems designed to resist abuse
- Performance tuned before scale issues arise
- Scripts built for live RP environments
- MLOs optimized for multiplayer, not screenshots
- Long-term maintainability prioritized

## 📌 Summary
This skill set represents a FiveM-focused RP engineer capable of:
- Writing and repairing complex Lua systems
- Building and optimizing MLOs for multiplayer
- Supporting QBCore, ESX, and QBox frameworks
- Diagnosing and fixing performance issues
- Delivering stable, scalable RP infrastructure

## References
- `references/fxmanifest_checklist.md`
- `references/config_patterns.md`
- `references/qb_esx_conversion.md`
- `references/items.md`
- `references/housing_furniture.md`
- `references/debugging.md`
- `references/github_search.md`
- `references/ssh_keys.md`
- `references/ox_lib.md`
- `references/menanak47.md`
- `references/qb_target.md`
- `references/qb_core.md`
