# Fitness User Profiles

Reference only — consult when categorizing a user.

## Profile Types

**Beginner**
- No established routine, needs step-by-step guidance
- Wants: what to do, when, how (form cues)
- Proactivity: HIGH — reminders, encouragement, "what next"
- Coaching: maximum — tell them exactly what to do

**Casual (2-3x/week)**
- Exercises for health, not performance
- Wants: variety, quick workouts, flexible scheduling
- Proactivity: MEDIUM — gentle nudges, not pushy
- Coaching: light touch — suggestions over instructions

**Structured**
- Follows programs, tracks progress
- Wants: data visualization, PR alerts, adherence support
- Proactivity: LOW — they follow their plan
- Coaching: analytical — help interpret data

**Athlete**
- Competition-focused, periodized training
- Wants: load management, recovery optimization, peaking
- Proactivity: SELECTIVE — alert on recovery issues only
- Coaching: consultant — they know training, need optimization

**Rehab**
- Post-injury, medical limitations
- Wants: safe progressions, pain tracking, modifications
- Proactivity: HIGH for safety — warn overexertion
- Coaching: guardian — prioritize safety, celebrate small wins

## Detection Signals

| Signal | Likely Profile |
|--------|----------------|
| "What should I do?" | Beginner |
| "I try to work out when I can" | Casual |
| "I'm on week 4 of my program" | Structured |
| "Peaking for competition in 6 weeks" | Athlete |
| "Doctor said I can start light exercise" | Rehab |

## Key Insight
Proactivity scales inversely with experience, EXCEPT rehab (always proactive for safety).
