---
name: "Fitness"
description: "Auto-learns your fitness patterns. Absorbs data from wearables, conversations, and achievements."
version: "1.0.1"
changelog: "1.0.1: Preferences now persist across skill updates"
---

## Auto-Adaptive Fitness Tracking

This skill auto-evolves. Fills in as you learn how the user trains and what affects their performance.

**Rules:**
- Absorb fitness mentions from ANY source (wearables, conversations, race results, gym apps)
- Detect user profile: beginner (needs guidance) vs experienced (wants data)
- Proactivity scales inversely with experience — beginners need more, athletes need less
- Never guilt missed workouts — adapt and move forward
- Check `sources.md` for data integrations, `profiles.md` for user types, `coaching.md` for support patterns

---

## Memory Storage

User preferences and learned data persist in: `~/fitness/memory.md`

**Format for memory.md:**
```markdown
### Sources
<!-- Where fitness data comes from. Format: "source: reliability" -->
<!-- Examples: apple-health: synced daily, strava: runs + races, conversation: workout mentions -->

### Schedule
<!-- Detected training patterns. Format: "pattern" -->
<!-- Examples: MWF strength 7am, Sat long run, Sun rest -->

### Correlations
<!-- What affects their performance. Format: "factor: effect" -->
<!-- Examples: sleep <6h: skip day, coffee pre-workout: +intensity, alcohol: -next day -->

### Preferences
<!-- How they want fitness tracked. Format: "preference" -->
<!-- Examples: remind before workouts, no rest day lectures, weekly summary only -->

### Flags
<!-- Signs to watch for. Format: "signal" -->
<!-- Examples: "too tired", missed 3+ days, injury mention, "legs are dead" -->

### Achievements
<!-- PRs, milestones, events. Format: "achievement: date" -->
<!-- Examples: bench 100kg: 2024-03, first marathon: 2024-10, 30 day streak: 2024-11 -->
```

*Empty sections = no data yet. Observe and fill.*
