# Program Design Guide

Read this when building or revising a program. Deep research what's best for this specific user — their goals, their equipment, their constraints, their life. Don't default to a generic template.

## Process

**Needs analysis first.** Before writing a single exercise: training age, movement quality, injury history, equipment, schedule constraints, recovery capacity (sleep, stress, nutrition). The program flows from this assessment — it's not a template with goals pasted on top.

**Research the method.** If the user wants a specific method, deep research the actual current source material and understand it before prescribing. If they don't have a preference, research what fits their needs analysis and explain why you chose it.

**Deep research means deep research.** Search current sources — peer-reviewed where possible, reputable coaching communities, established program documentation. Don't rely on what you already know. The user deserves current, validated information tailored to their specific situation.

## Design Principles

**Adherence is the foundation.** A 3-day program they do beats a 6-day program they abandon. Fit the schedule they have, not the one you wish they had. This overrides everything below.

**Train multiple fitness qualities.** Most people need more than just strength or hypertrophy. Consider: skill/technique, power, strength, hypertrophy, muscular endurance, anaerobic capacity, VO2max, and long-duration endurance. At minimum, most people benefit from resistance training (3x/week) + Zone 2 cardio (150-200 min/week) + one high-intensity session per week. The interference effect between strength and endurance is overblown — Zone 2 at conversational pace doesn't meaningfully block hypertrophy.

**Execution determines adaptation, not exercise selection.** The same movement trains strength, power, or hypertrophy depending on load, intent, rest, and volume. Program the parameters, not just the exercises.

**Match protocols to the goal:**
- **Strength/Power:** 3-5 exercises, 3-5 sets of 3-5 reps, 3-5 min rest, 70%+ 1RM. No need to train to failure.
- **Hypertrophy:** 10-20 sets/muscle/week, 8-15 reps (range of 4-30 works), ~2 min rest, stop ~2 reps short of failure. Volume is the primary driver.
- **Zone 2 endurance:** 30-75 min continuous at conversational/nasal-breathing pace. If they must mouth-breathe, slow down.
- **HIIT/anaerobic:** 4-8 intervals of 20-90 sec max effort, 1-2x/week. ~5-6 total minutes at max HR per week. Rest until nasal breathing returns between intervals.

**Mesocycles have shape — flat programs are not programs.** Structure each mesocycle as 3-5 weeks of accumulation + 1 week deload. Start volume near minimum effective dose (~6-10 hard sets/muscle/week), add 1-3 sets/week, approach maximum recoverable volume by the final week, then deload. Intensity progresses from conservative (3-4 RIR in week 1) to challenging (0-1 RIR in the final week). If every week looks the same, it's a list of exercises, not a program.

**Use autoregulation over fixed percentages** (for intermediates+). Prescribe "4x6 @ RPE 8" not "4x6 @ 80%." This adjusts for daily readiness. For beginners who can't gauge effort yet, use simple rep targets: "add weight when you get all reps across all sets."

**Progressive overload has six levers — not just "add weight."** Load, volume (sets/reps), density (shorter rest), range of motion, tempo (slow eccentrics, pauses), and complexity (bilateral → unilateral, stable → unstable). When one stalls, progress through the others.

**Select exercises by movement pattern, not by name.** Horizontal push, vertical push, horizontal pull, vertical pull, hip hinge, squat/knee-dominant, carry/core. Balance all patterns across the week. For bodyweight: include horizontal and vertical planes for both push and pull. For each muscle group, choose exercises that load both the lengthened and shortened positions. Every pattern needs a substitution chain.

**Sequence intelligently.** Compounds before isolation. Most fatiguing movements first in the session. Don't stack competing recovery demands on consecutive days (e.g., heavy squats and heavy deadlifts share hip/back recovery).

**Choose the right periodization model for the person.** Beginners: linear (simple, works). Intermediates training 3-4x/week with no competition date: daily undulating (vary rep ranges across the week). Advanced with peaking needs: block periodization. Don't default to linear for everyone.

## Recovery Principles

**Training is the signal; recovery is the adaptation.** Muscle growth, strength gains, and motor learning all consolidate during rest — not during the workout. Never sacrifice recovery for additional training volume.

**Sleep is the master recovery tool.** 7-8 hours minimum. Growth hormone releases during deep sleep in the first half of the night. If sleep is poor, consider postponing the workout rather than training through it — the injury and illness risk outweighs the missed session.

**Post-training nervous system downregulation.** 3-5 minutes of deliberate slow breathing after every session to shift from sympathetic to parasympathetic. Double inhale through nose, long exhale through mouth (physiological sigh) is the fastest method.

**Cold exposure timing matters.** Cold water immersion within 4-6 hours after strength or hypertrophy training can blunt the adaptation signal. It's fine after endurance work. If the user uses cold exposure, schedule it before training or 6+ hours after strength work.

**Anti-inflammatory timing.** The inflammatory response after training IS the adaptation signal. Avoid NSAIDs, ice, or high-dose anti-inflammatory supplements immediately post-training — they can blunt the gains.

**Watch for overreaching.** Declining performance across sessions, elevated resting HR, persistent soreness, disrupted sleep, loss of motivation. When 2+ co-occur, deload immediately — don't wait for the scheduled deload.

**Deload is not optional.** Every 3-6 weeks, or immediately when overreaching signs appear. Deload = maintenance volume at 50-60% working loads. Maintain movement patterns, cut intensity and volume.

## What a Complete Program Includes

- **The Why** — rationale for the approach, so the user understands the reasoning
- **Weekly schedule** with environment adaptations (rain plan, travel plan, no-gym plan)
- **Daily non-negotiables** — skill practice, mobility, things that happen regardless of the main workout
- **Full workout templates** — warm-up through finisher, with exact exercises, sets, reps, rest, effort targets
- **Progression ladders for every exercise** — specific levels with clear criteria to advance. For bodyweight: progression through leverage and difficulty, each step spelled out.
- **Deload protocol** — what it looks like, triggers for unscheduled deloads
- **Substitution chains** organized by movement pattern
- **Alternative workouts** for constrained environments (home, hotel, rain day)
- **Rehab/prehab prescriptions** for issues relevant to the user
- **Benchmarks** — what to test and how often
- **Week 1 checklist** — clear first steps

Write the full program to `fitness/program.md`. It should be complete enough that the user could follow it without you — like a printed program from a real coach. Update `FITNESS.md` with the summary.
