# Common Assumption Traps — First Principles

## The Seven Hidden Assumptions

### 1. Historical Assumption
**Pattern:** "We've always done it this way"

**Examples:**
- QWERTY keyboard layout (designed to slow typing)
- 8-hour workday (factory-era constraint)
- Annual performance reviews (calendar-based, not logic-based)

**Questions to expose:**
- When did this start? Why?
- Has the original reason changed?
- If starting fresh today, would we choose this?

### 2. Authority Assumption
**Pattern:** "Experts/leaders say X"

**Examples:**
- "The market is saturated" (expert opinion, not physics)
- "Users won't pay for this" (assumption about behavior)
- "That technology won't scale" (prediction, not fact)

**Questions to expose:**
- What evidence supports this claim?
- What would falsify it?
- Have authorities been wrong about similar things?

### 3. Analogical Assumption
**Pattern:** "It's just like X, so Y applies"

**Examples:**
- "Social networks are like broadcast media" (different dynamics)
- "Electric cars are like gas cars" (fundamentally different tech)
- "AI is like previous automation" (potentially different in kind)

**Questions to expose:**
- What are the underlying mechanics of each?
- Where does the analogy break down?
- What's different that matters?

### 4. Social Assumption
**Pattern:** "Everyone does it / no one does it"

**Examples:**
- "Customers won't accept that" (until someone proves otherwise)
- "The industry standard is X" (standard ≠ optimal)
- "That's not how business works" (until it is)

**Questions to expose:**
- Is this optimal or just common?
- Who benefits from this being the norm?
- What would happen if we ignored it?

### 5. Resource Assumption
**Pattern:** "We can't afford to / don't have capacity"

**Examples:**
- "We don't have the budget" (budget is a choice)
- "We don't have the talent" (talent can be built/bought)
- "We don't have time" (priorities can shift)

**Questions to expose:**
- Is this a real constraint or a prioritization choice?
- What if this resource appeared tomorrow?
- What's the constraint behind the constraint?

### 6. Technical Assumption
**Pattern:** "The technology can't do X"

**Examples:**
- "Batteries can't store enough" (chemistry evolves)
- "Networks can't handle the load" (infrastructure scales)
- "AI can't do creative work" (capabilities expand)

**Questions to expose:**
- Is this a physics limit or an engineering limit?
- What's the theoretical maximum?
- What's improving and at what rate?

### 7. Market Assumption
**Pattern:** "Customers want/don't want X"

**Examples:**
- "People won't pay subscription for music" (pre-Spotify)
- "No one wants a computer at home" (pre-PC)
- "People need physical keyboards" (pre-iPhone)

**Questions to expose:**
- Is this based on stated preference or revealed behavior?
- Has the underlying need been tested differently?
- Are we solving the right problem?

## Assumption Detection Phrases

When you hear these, assumptions are likely hiding:

| Phrase | Hidden Assumption |
|--------|-------------------|
| "Obviously..." | Something isn't being questioned |
| "Everyone knows..." | Consensus ≠ truth |
| "It's impossible to..." | Difficulty confused with impossibility |
| "The problem is..." | Problem definition may be wrong |
| "We tried that and..." | Conditions may have changed |
| "The data shows..." | Data interpretation may be flawed |
| "Best practices say..." | Best for whom? When? |

## Assumption Stress Test

For each identified assumption:

1. **State it explicitly** — Write it as a clear claim
2. **Find the origin** — Where did this belief come from?
3. **Seek disconfirmation** — What would prove it wrong?
4. **Imagine the opposite** — What if the reverse were true?
5. **Test minimally** — Can we quickly validate/invalidate?

## The "Alien Test"

Imagine explaining your constraints to an intelligent alien with no human context:

- Would they accept "that's how it's done" as a reason? → No
- Would they accept "experts believe" without evidence? → No
- Would they accept "it's too hard" without physics proof? → No

**If you can't justify it to an alien, it might be an assumption.**

## Recovery: When You've Found an Assumption

1. **Don't discard immediately** — Assumptions exist for reasons
2. **Understand the history** — Why did it become assumed?
3. **Evaluate current validity** — Does the reason still apply?
4. **Consider costs** — What's the cost of challenging it?
5. **Test incrementally** — Don't bet everything on being right

**Most assumptions were once valid solutions. Some still are.**
