# Integrated Thinking Frameworks

## Combined Approach: First Principles + Design Thinking + Systems Engineering

For deep problem solving, combine three complementary frameworks:

---

## 1. First Principles (Musk Method)

**Core Question**: What is fundamentally true?

### Process
1. Identify assumptions
2. Break to atomic truths
3. Rebuild from fundamentals

### Best For
- Challenging conventional wisdom
- Finding non-obvious solutions
- Cost reduction / efficiency

---

## 2. Stanford Design Thinking (IDEO Method)

**Core Question**: What do humans actually need?

### The Five Stages
1. **Empathize** - Deeply understand user needs, pain, context
2. **Define** - Frame the real problem (often different from stated problem)
3. **Ideate** - Generate many solutions without judgment
4. **Prototype** - Build quick, cheap versions to test
5. **Test** - Learn from real user feedback, iterate

### Key Practices
- **Beginner's Mind**: Approach without assumptions
- **How Might We**: Reframe problems as opportunities
- **Rapid Prototyping**: Learn fast, fail cheap
- **User-Centered**: Always return to user needs

### Best For
- User-facing products
- Innovation and new concepts
- Understanding unmet needs

---

## 3. MIT Systems Engineering

**Core Question**: How do the parts interact?

### Systems Thinking Principles
1. **Holistic View**: System behavior emerges from interactions
2. **Feedback Loops**: Outputs affect inputs (positive/negative)
3. **Boundaries**: Define system vs environment
4. **Hierarchy**: Systems contain subsystems
5. **Emergence**: Whole > sum of parts

### Analysis Framework
```
INPUTS → PROCESSES → OUTPUTS → FEEDBACK
         ↑                      ↓
         ←─────────────────────←
```

### Key Questions
- What are the system boundaries?
- Where are the feedback loops?
- What are the leverage points?
- What are the unintended consequences?

### Best For
- Complex multi-component problems
- Long-term strategic thinking
- Avoiding unintended consequences

---

## The Integrated Method

Use all three in sequence:

```
PHASE 1: First Principles
"What is fundamentally true about this problem?"
→ Strip away assumptions, find atomic truths

PHASE 2: Design Thinking
"What do users actually need?"
→ Empathize, define real problem, ideate solutions

PHASE 3: Systems Engineering
"How will this solution interact with its environment?"
→ Map feedback loops, identify leverage points, predict consequences
```

## When to Use Which

| Situation | Primary | Supporting |
|-----------|---------|------------|
| Challenging industry norms | First Principles | Design Thinking |
| New product/feature | Design Thinking | Systems |
| Complex org problem | Systems | First Principles |
| Optimization task | First Principles | Systems |
| Innovation sprint | Design Thinking | First Principles |

## Combined Output Format

```markdown
## First Principles Analysis
**Assumptions Challenged:**
- [assumption] → [fundamental truth]

## Design Thinking Synthesis
**User Need:** [What they really need]
**How Might We:** [Reframed problem]
**Solution Concepts:** [Top 3 ideas]

## Systems View
**Key Feedback Loops:**
- [loop 1]
- [loop 2]

**Leverage Points:**
- [where small changes have big effects]

**Potential Unintended Consequences:**
- [second-order effects to monitor]
```

---

## Integration with Other Skills

This combined framework feeds into:
- **inversion-strategist** - Invert the systems view to find failure modes
- **second-order-consequences** - Map ripple effects of solutions
- **pre-mortem-analyst** - Stress-test before implementing
