---
name: firm-delivery-export
version: 1.0.0
description: >
  Post-processing skill for firm-orchestration: converts the structured JSON output
  of a multi-agent workflow run into real deliverables — GitHub Pull Requests,
  Jira/Linear tickets, Markdown reports, project briefs or structured documents.
  Acts as the last-mile bridge between agent output and team tooling.
author: romainsantoli-web
license: MIT
metadata:
  openclaw:
    requires:
      env:
        - GITHUB_TOKEN
        - JIRA_API_TOKEN
        - JIRA_BASE_URL
        - LINEAR_API_KEY
      bins:
        - curl
    tools:
      - bash
    primaryEnv: "GITHUB_TOKEN"
tags:
  - delivery
  - export
  - github
  - jira
  - linear
  - output
  - firm
  - enterprise
---

# firm-delivery-export

Converts firm workflow output into **real deliverables** in team tooling.

## Supported formats

| Format | Target | Required env |
|---|---|---|
| `github_pr` | GitHub repository PR | `GITHUB_TOKEN` |
| `jira_ticket` | Jira issue | `JIRA_API_TOKEN` + `JIRA_BASE_URL` |
| `linear_issue` | Linear issue | `LINEAR_API_KEY` |
| `markdown_report` | Local file / chat | none |
| `structured_document` | Markdown with frontmatter | none |
| `project_brief` | Structured PDF-ready doc | none |
| `slack_digest` | Slack message via webhook | `SLACK_WEBHOOK_URL` |

## Usage (after firm-orchestration run)

```
Use firm-delivery-export to publish last workflow result as a GitHub PR:
  repo: "myorg/myrepo"
  branch: "ai/sprint-24-plan"
  title: "feat: Sprint 24 plan (AI-generated, human review pending)"
  reviewers: ["@john", "@sarah"]
```

## GitHub PR output schema

```json
{
  "format": "github_pr",
  "repo": "org/repo",
  "branch": "ai/{kebab-objective}",
  "base": "main",
  "title": "...",
  "body": "## AI-generated delivery\n\n{merged_output}\n\n---\n_Generated by firm-orchestration_",
  "draft": true,
  "reviewers": [],
  "labels": ["ai-generated", "needs-review"]
}
```

## Jira ticket output schema

```json
{
  "format": "jira_ticket",
  "project": "ENG",
  "issue_type": "Story",
  "summary": "...",
  "description": "{merged_output}",
  "priority": "Medium",
  "labels": ["ai-generated"],
  "components": []
}
```

## Security notes

- `GITHUB_TOKEN` must have `repo` scope — use fine-grained tokens scoped to target repo
- All PRs are created as **drafts** by default (`draft: true`) — never auto-merged
- Human review is mandatory: a `needs-review` label is applied unconditionally
- `JIRA_API_TOKEN` is never logged (masked in audit trail)
- Slack webhook URLs are treated as secrets (masked in JSONL audit)

## Error handling

| Error | Behavior |
|---|---|
| API rate limit | Retry with exponential backoff (3 attempts, max 30s) |
| Auth failure | Fail fast, output error to session, never retry |
| Network timeout | Fallback to `markdown_report` format locally |
| Invalid schema | Reject with validation error listing missing fields |

## Example with delivery pipeline

```
1. Run firm-orchestration:
   objective: "Document the payment service API"
   departments: ["engineering", "operations"]
   delivery_format: "github_pr"

2. Run firm-delivery-export automatically:
   → Creates draft PR "docs: Payment service API documentation"
   → Branch: ai/document-payment-service-api
   → Labels: ai-generated, needs-review, documentation
   → Assigns to @team-engineering for review
```

---

## 💎 Support

Si ce skill vous est utile, vous pouvez soutenir le développement :

**Dogecoin** : `DQBggqFNWsRNTPb6kkiwppnMo1Hm8edfWq`
