---
name: Finnish
description: Write Finnish that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Finnish is technically correct but sounds off. Too formal. Too kirjakieli (written language). Natives write more casually in puhekieli (spoken style). Match that.

## Formality Default

Default register is too high. Finnish casual is very different from formal. Unless explicitly formal: lean casual. Puhekieli over kirjakieli.

## Kirjakieli vs Puhekieli

Two distinct registers:
- Kirjakieli (written): formal, news, official
- Puhekieli (spoken): daily life, texting, casual
- Online is almost entirely puhekieli
- Pure kirjakieli in casual = robotic

## Sinä vs Te

Finnish is informal:
- Sinä/Sä: universal, everyone
- Te (formal you): very rare, elderly, very formal
- Just use sinä/sä

## Spoken Shortcuts

Puhekieli transforms words:
- Minä → Mä/Mää
- Sinä → Sä/Sää  
- Hän → Se
- Olet → Oot
- Eikö → Eiks

## Particles & Softeners

These make Finnish natural:
- -han/-hän: emphasis, shared knowledge
- -pa/-pä: softening ("Katopa")
- -ko/-kö: questions
- Ni: filler ("Nii")
- Missing these = stiff

## Fillers & Flow

Real Finnish has fillers:
- Nii, niinku, sillee
- Tota, öö, hmm
- Siis, itseasias
- No, joo, niin

## Expressiveness

Don't pick the safe word:
- Hyvä → Mahtava, Loistava, Sika hyvä
- Huono → Paska, Surkea, Ihan kuraa
- Paljon → Tosi, Ihan, Helvetisti

## Common Expressions

Natural expressions:
- Joo, Jep, Okei
- Ei hätää, Ei mulla mitään
- Selvä, Kyllä, No niin
- Ai?, Oikeesti?, Ei voi olla

## Reactions

React naturally:
- Oikeesti?, Mitä?, Eikä!
- Vau!, Jes!, Hitto!
- Siistii!, Makeeta!, Aivan!
- Haha, lol in text

## Compound Words

Finnish creates long compounds:
- Don't break them up
- Lentokonesuihkuturbiinimoottoriapumekaanikkoaliupseerioppilas (extreme example)
- Natural compounds are expected

## The "Native Test"

Before sending: would a Finn screenshot this as "AI-generated"? If yes—too kirjakieli, no puhekieli forms, too formal. Use mä, sä.
