---
name: find-products
version: 1.0.0
description: Search and discover trending products from ProductHunt with structured analysis data. Use when users ask about product recommendations, tool comparisons, or trending apps.
homepage: https://github.com/xiazhefengzhi/find-products-skill
---

# find-products

Search ProductHunt products with structured analysis from trend-hunt.com.

## When to Use

Trigger this skill when the user:
- Asks for product or tool recommendations (e.g., "What are the best AI video tools?")
- Wants to compare products in a category
- Asks about trending products or apps
- Needs to find alternatives to a specific product
- Asks "what tools exist for X"

## How to Search

Make a GET request to the search API:

```bash
curl -s "https://trend-hunt.com/api/search?q=QUERY&locale=LOCALE&limit=LIMIT&category=CATEGORY"
```

### Parameters

| Parameter  | Required | Default | Description |
|------------|----------|---------|-------------|
| `q`        | Yes      | —       | Search keywords (supports English and Chinese) |
| `locale`   | No       | `en`    | Language: `en` or `zh` |
| `limit`    | No       | `10`    | Number of results (1–20) |
| `category` | No       | —       | Filter by category |

### Common Categories

`AI`, `Productivity`, `Developer Tools`, `Design`, `Marketing`, `Analytics`, `Writing`, `Video`, `Audio`, `Education`, `Finance`, `Social`, `Health`, `E-commerce`

## Response Format

The API returns JSON:

```json
{
  "success": true,
  "query": "video editor",
  "locale": "en",
  "count": 5,
  "products": [
    {
      "slug": "product-slug",
      "name": "Product Name",
      "tagline": "Short description",
      "category": "AI",
      "upvotes": 523,
      "hypeScore": 85,
      "utilityScore": 78,
      "metaphor": "It's like Canva but for video editing",
      "phUrl": "https://www.producthunt.com/posts/product-slug",
      "websiteUrl": "https://product.com",
      "positiveReviews": ["Great UI", "Fast rendering"],
      "negativeReviews": ["Limited free tier"],
      "newbieQA": [...],
      "translations": [...]
    }
  ]
}
```

## How to Present Results

Format each product as:

```
### Product Name
⭐ Upvotes: 523 | Hype: 85 | Utility: 78
> Metaphor: "It's like Canva but for video editing"

**Tagline**: Short description
**Category**: AI
**Pros**: Great UI, Fast rendering
**Cons**: Limited free tier

🔗 [ProductHunt](phUrl) | [Website](websiteUrl)
```

## Examples

### Example 1: Find AI writing tools
```bash
curl -s "https://trend-hunt.com/api/search?q=AI+writing&locale=en&limit=5"
```

### Example 2: Search in Chinese
```bash
curl -s "https://trend-hunt.com/api/search?q=视频编辑&locale=zh&limit=5"
```

### Example 3: Filter by category
```bash
curl -s "https://trend-hunt.com/api/search?q=automation&category=Productivity&limit=10"
```

## Tips

- Use English keywords for broader results; the database has more English content
- When `locale=zh`, translated fields appear in the `translations` array
- Products are sorted by upvotes (most popular first)
- `hypeScore` = community excitement; `utilityScore` = practical value
- The `metaphor` field gives a quick "it's like X for Y" comparison
- If no results are found, try broader or alternative keywords
