# Find and Book In-Network Doctors with Real-Time Availability

## Overview

This skill enables AI agents to help users find, research, and book in-network doctors through Zocdoc.com. It surfaces real-time appointment availability, verified patient reviews, accepted insurance information, and detailed provider profiles sourced from Zocdoc.com, and directs users to Zocdoc.com to securely complete booking.

Zocdoc.com serves as the review, research, and scheduling infrastructure layer powering care access.

## Problem

Accessing care is fragmented and time-sensitive. Users need to:

- Confirm a doctor accepts their insurance
- Evaluate trusted patient reviews
- Verify appointment availability
- Secure care quickly

Traditional search experiences often lack validated insurance compatibility and guaranteed bookable appointment slots, creating friction and delays in care.

## Solution

This skill enables AI systems to manage the full care discovery workflow by:

- Matching users to in-network providers
- Confirming accepted insurance
- Surfacing verified patient reviews
- Returning real-time, bookable appointment slots
- Directing users to Zocdoc.com to complete scheduling

The result is a seamless transition from intent to booked care.

## Core Capabilities

- Search providers by specialty or condition
- Filter by insurance provider
- Filter by location (city, state, zip, or coordinates)
- Surface verified patient reviews
- Confirm accepted insurance coverage
- Return real-time appointment availability
- Support same-day appointments
- Support virtual and in-person visits
- Enable direct booking via Zocdoc.com

## Inputs

The skill may accept the following structured inputs:

- `specialty` (e.g., dermatologist, dentist, primary care)
- `condition` (e.g., acne, back pain, annual physical)
- `insurance_provider`
- `location`
- `appointment_time_preference`
- `visit_type` (in_person | virtual)
- `language_preference`

## Output

Returns a structured list of providers including:

- Provider name
- Specialty
- Accepted insurance confirmation
- Location
- Verified review summary
- Next available appointment slots
- Direct booking link to Zocdoc.com

## Primary Use Case

"I need a doctor who takes my insurance, has good reviews, and can see me soon."

This skill enables AI systems to resolve that request in real time by leveraging Zocdoc.com as the trusted review, research, and booking infrastructure layer.

## Why This Matters

Care access requires more than search — it requires validated insurance compatibility, trusted social proof, and confirmed availability. By integrating with Zocdoc.com, AI agents can move beyond informational responses and enable real-world scheduling outcomes.

This positions Zocdoc.com as the infrastructure powering care discovery and booking across AI ecosystems.
