# Query Examples

## Spending Totals

| Query | What it does |
|-------|-------------|
| "How much did I spend this month?" | Total spending for current month |
| "Total spending last month" | Sum of all expenses last month |
| "How much on groceries in January?" | Grocery spending for January |
| "What did I spend on dining last 30 days?" | Dining total for past 30 days |
| "Total transport costs this year" | Year-to-date transport spending |

## Transaction Counts

| Query | What it does |
|-------|-------------|
| "How many transactions this month?" | Count of all transactions |
| "Number of grocery transactions last month" | Count of grocery purchases |
| "How many dining transactions this week?" | Dining transaction count this week |

## Averages

| Query | What it does |
|-------|-------------|
| "Average grocery spending" | Average amount per grocery transaction |
| "What's my typical dining expense?" | Average dining transaction |
| "Average monthly spending on subscriptions" | Average subscription cost |

## Extremes

| Query | What it does |
|-------|-------------|
| "What was my largest transaction?" | Biggest single expense this month |
| "Most expensive purchase last month" | Largest transaction last month |
| "Smallest transaction this month" | Cheapest purchase this month |

## Lists

| Query | What it does |
|-------|-------------|
| "Show all transactions this month" | List all transactions (default limit 20) |
| "List recent grocery purchases" | Recent grocery transactions |
| "Show top 5 transactions this month" | 5 largest transactions |
| "Display all dining last week" | All dining transactions last week |

## Time References

The query parser understands these time expressions:

- **Relative**: this month, last month, this week, last week, today, yesterday
- **Duration**: last 7 days, last 30 days, last 3 months, last 2 weeks
- **Named months**: January, Feb, March 2024
- **Year**: this year, last year, 2024
- **Date range**: 2024-01-01 to 2024-03-31

## Category Keywords

Use any of these words to filter by category:

- **Groceries**: grocery, groceries, food, supermarket
- **Dining**: dining, restaurants, restaurant, eating out, food delivery
- **Transport**: transport, transportation, gas, uber, lyft, transit, commute
- **Utilities**: utilities, bills, electric, internet, phone
- **Subscriptions**: subscriptions, streaming, netflix, spotify
- **Shopping**: shopping, retail, amazon, online shopping, clothes
- **Healthcare**: healthcare, health, medical, pharmacy, doctor
- **Entertainment**: entertainment, fun, movies, travel, hotels
- **Income**: income, salary, earnings, deposits, refunds
