---
name: financial-planning
description: Plan and manage the finances of a solopreneur business. Use when creating budgets, forecasting revenue and expenses, building a P&L, planning for cash flow, setting financial targets, or preparing for financial decision-making. Covers budgeting frameworks, cash flow management, profit margins, expense tracking categories, and financial dashboards. Trigger on "financial plan", "budget my business", "cash flow planning", "P&L", "profit and loss", "financial projections", "how much do I need", "business finances", "financial forecast".
---

# Financial Planning

## Overview
Most solopreneurs avoid financial planning until something goes wrong — a surprise tax bill, a month where expenses eat all revenue, or a decision made without understanding the numbers. This playbook gives you a lightweight but rigorous financial system that takes 30 minutes to set up and 15 minutes per month to maintain. No accounting degree required.

---

## Step 1: Set Up Your Financial Reality Baseline

Before planning, know where you actually stand right now.

**Gather these numbers (estimate if you don't have exact figures):**
- Monthly revenue (average of last 3 months if you have history; projected if pre-revenue)
- Monthly fixed expenses (rent/co-working, tools/subscriptions, insurance, hosting, internet — things that don't change month to month)
- Monthly variable expenses (marketing spend, contractor payments, per-transaction fees, travel — things that fluctuate)
- One-time expenses coming up in the next 6 months (equipment, legal, conferences, annual subscriptions)
- Personal income need (the minimum you need to pay yourself each month to cover personal living costs)

**Write these down. This is your baseline. Everything else in this playbook builds on it.**

---

## Step 2: Build Your Monthly Budget

A budget is simply: how much money do you plan to spend in each category, and how much do you plan to bring in?

**Budget structure:**

```
MONTHLY BUDGET
==============

REVENUE
  Product/Service Revenue:        $________
  Secondary Revenue Streams:      $________
  TOTAL REVENUE:                  $________

EXPENSES — FIXED
  Hosting & Infrastructure:       $________
  Tools & Software:               $________
  Insurance:                      $________
  Legal / Professional Services:  $________
  Other Fixed:                    $________
  TOTAL FIXED:                    $________

EXPENSES — VARIABLE
  Marketing & Advertising:        $________
  Contractor / Freelancer:        $________
  Payment Processing Fees:        $________
  Travel & Events:                $________
  Education & Learning:           $________
  Other Variable:                 $________
  TOTAL VARIABLE:                 $________

TOTAL EXPENSES:                   $________  (Fixed + Variable)

GROSS PROFIT:                     $________  (Revenue - Expenses)

OWNER SALARY (your pay):          $________

NET PROFIT (retained in business):$________  (Gross Profit - Owner Salary)
```

**Rules:**
- Marketing budget should be 10-20% of revenue (or a fixed dollar amount if pre-revenue — treat it as an investment with expected ROI).
- Owner salary should be set first, then expenses fit around it. If expenses + salary > revenue, something must be cut or revenue must grow.
- Always budget a 10-15% buffer for unexpected costs. Unexpected things always happen.

---

## Step 3: Cash Flow Forecasting

Revenue on paper is not cash in your account. Cash flow timing is what actually keeps a business alive.

**Monthly cash flow forecast (do this 3 months ahead):**

```
CASH FLOW FORECAST
==================
                        Month 1    Month 2    Month 3
Starting Cash:          $________  $________  $________
+ Revenue In:           $________  $________  $________
- Expenses Out:         $________  $________  $________
= Ending Cash:          $________  $________  $________
```

**Cash flow timing rules:**
- Revenue often comes in AFTER the work is done (invoices have Net-15 or Net-30 terms). Budget for this lag.
- Some expenses are lumpy (annual subscriptions, quarterly contractor payments). Spread these into monthly equivalents in your budget so you're not surprised.
- Keep a cash reserve of 2-3 months of expenses. This is your runway buffer. Without it, one bad month can threaten the business.

**Cash flow danger signals:**
- Ending cash drops below 1 month of expenses → urgent. Cut spending or accelerate collections immediately.
- Revenue is growing but cash is flat → you're spending everything you earn. Examine variable expenses.
- Revenue is lumpy (big months, dead months) → smooth it out with recurring revenue models or build a larger cash reserve.

---

## Step 4: Set Financial Targets

Targets give you something to measure against and decisions to make when you're off track.

**Set targets at three horizons:**

**Monthly targets:**
- Minimum revenue to cover expenses + salary
- Marketing spend cap
- New customer acquisition count

**Quarterly targets:**
- Revenue growth rate (e.g., 10-15% quarter over quarter)
- Profit margin target (aim for 30-50% net margin as a solopreneur)
- Cash reserve target (build toward 3 months of expenses)

**Annual targets:**
- Total annual revenue
- Total annual profit
- Owner salary / total compensation target
- Business milestones (launch date, customer count, revenue milestone)

**When you miss a target:** Don't panic. Analyze why. Was it a bad assumption? An external factor? A controllable mistake? Adjust the plan, not just the target.

---

## Step 5: Track Monthly (The 15-Minute Review)

At the end of every month, spend 15 minutes on this review:

1. **Actual vs. Budget:** Compare every line in your budget to what actually happened. Where did you overspend? Underspend?
2. **Revenue vs. Target:** Did you hit your revenue target? If not, why?
3. **Cash position:** What's your current cash balance? Are you above or below your reserve target?
4. **One action:** Based on this review, identify ONE financial action for next month. (e.g., "Reduce contractor spend by $500", "Raise prices on new customers", "Collect overdue invoice from Client X")

**Tools for tracking:** A shared Google Sheet is sufficient for most solopreneurs. Dedicated tools (QuickBooks, FreshBooks, Wave) add value once revenue exceeds $5K/month or you have complex expenses. Wave is free and handles basic bookkeeping well.

---

## Step 6: Tax Planning (Integrated, Not Afterthought)

Tax is an expense like any other. Budget for it monthly — not just once a year in a panic.

**Solopreneur tax budget rule:** Set aside 25-30% of every revenue payment into a separate "tax savings" account. This covers:
- Self-employment tax (Social Security + Medicare)
- Federal and state income tax
- Quarterly estimated tax payments (due Jan 15, Apr 15, Jun 15, Sep 15 in the US)

**If you're outside the US:** Tax rules vary enormously by country. The percentage may differ but the principle is the same — set aside a fixed percentage of revenue immediately, before you spend it.

**If you haven't been doing this and owe back taxes:** Calculate the total owed, divide by the months until the deadline, and set that aside each month. Do not ignore it.

---

## Financial Planning Mistakes to Avoid
- Treating revenue as profit. Revenue minus expenses = profit. Many solopreneurs conflate the two.
- Not paying yourself a salary. If you don't pay yourself, you don't know if the business is actually profitable for YOU.
- Ignoring taxes until April (or your country's equivalent). Tax surprises are the #1 financial crisis for solopreneurs.
- Budgeting optimistically. Budget conservatively on revenue (assume less), aggressively on expenses (assume more). Positive surprises are much better than negative ones.
- Never revisiting the budget. A budget set in January is stale by March. Update monthly.
