# Financial Data Visualization

Patterns for building dark-themed financial charts and data visualizations. Covers chart theming, color scales for gains/losses, and real-time data display for trading dashboards and financial analytics.

## What's Inside

- Chart color palette (gains/losses, backgrounds, text, multi-series)
- Recharts theme configuration (axes, grid, tooltip styling)
- Price chart component with gradient fills
- Candlestick color schemes
- Percentage bar component (positive/negative)
- Mini sparkline SVG component
- Chart legend component

## When to Use

- Building trading dashboards with charts
- Displaying portfolio performance
- Showing price history and trends
- Any financial data visualization

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/design-systems/financial-data-visualization
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/design-systems/financial-data-visualization .cursor/skills/financial-data-visualization
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/design-systems/financial-data-visualization ~/.cursor/skills/financial-data-visualization
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/design-systems/financial-data-visualization .claude/skills/financial-data-visualization
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/design-systems/financial-data-visualization ~/.claude/skills/financial-data-visualization
```

## Related Skills

- [animated-financial-display](../animated-financial-display/) — Number animations and value flash effects
- [design-system-creation](../../meta/design-system-creation/) — Complete design system workflow
- [dual-stream-architecture](../../realtime/dual-stream-architecture/) — Real-time data streaming patterns

---

Part of the [Design Systems](..) skill category.
