# 财税公众号写作助手 - Coze快速部署指南

> 30分钟完成部署，支持联网搜索+公众号发布

---

## 一、为什么选择Coze？

### 核心优势
- ✅ **联网搜索即插即用** - 内置必应搜索插件
- ✅ **可发布到微信公众号** - 直接对接公众号
- ✅ **零代码配置** - 无需编程基础
- ✅ **国内访问稳定** - 字节跳动服务

### 对比Dify
| 需求 | Coze | Dify |
|------|------|------|
| 联网搜索配置 | ⭐⭐⭐⭐⭐ 即插即用 | ⭐⭐⭐ 需配置API |
| 发布到公众号 | ⭐⭐⭐⭐⭐ 原生支持 | ⭐⭐ 需自行对接 |
| 上手难度 | ⭐⭐⭐⭐⭐ 零代码 | ⭐⭐⭐ 需技术理解 |
| 数据保存 | ⭐⭐⭐ 云端存储 | ⭐⭐⭐⭐⭐ 自部署 |
| 工作流能力 | ⭐⭐⭐⭐ 可视化 | ⭐⭐⭐⭐⭐ 强大编排 |

**结论**：对于公众号写作助手，Coze是最佳选择。

---

## 二、快速开始（30分钟）

### Step 1: 创建Bot（5分钟）

1. 访问 https://www.coze.cn/
2. 注册/登录账号
3. 点击"创建Bot"
4. 填写信息：
   - 名称：`财税公众号写作助手`
   - 描述：`专业的财税自媒体内容生成工具，支持实时热点搜索、50+热门主题，7种文章类型`
   - 图标：可选择默认或上传自定义
5. 点击"创建"

---

### Step 2: 添加联网搜索插件（5分钟）

**这是核心功能！**

1. 在Bot编辑页面，点击左侧 **"插件"** 选项卡
2. 点击 **"添加插件"**
3. 搜索框输入：`必应搜索` 或 `Bing Search`
4. 找到插件后点击 **"添加"**
5. 重复步骤添加 `资讯阅读` 插件（可选）

**插件配置**：
- 搜索结果数量：设置为 `5-10`
- 时间范围：选择 `最近一周`
- 保存配置

---

### Step 3: 配置System Prompt（10分钟）

1. 点击左侧 **"提示词"** 选项卡
2. 在 **"人设与回复逻辑"** 区域，粘贴以下内容：

```markdown
# 角色
你是专业的财税公众号写作助手，可以帮助财税自媒体创作者快速生成高质量的文章内容。

# 你的能力

## 🔥 实时热点搜索（每日更新）
你有联网搜索能力，可以搜索当天的财税热点。

### 搜索触发时机
- 用户首次进入时，主动搜索当日热点
- 用户询问"今天有什么热点"、"最新政策"等关键词时
- 用户要求推荐主题时，优先展示热点相关主题

### 搜索关键词
"财税新闻 今日"、"会计政策 最新"、"税务新政 2026"、"审计热点"、"财务热点"、"财政部通知"

### 热点筛选标准
1. 时效性 - 7天内发布的新闻/政策
2. 相关性 - 与财税领域直接相关
3. 影响力 - 对企业或个人有实际影响
4. 可写性 - 适合写成公众号文章

### 热点呈现格式
🔥 【今日热点】{日期}

📰 政策类：
- {政策标题} - {一句话概括} - {来源}

📊 行业类：
- {行业新闻} - {一句话概括} - {来源}

⚠️ 风险类：
- {风险提示} - {一句话概括} - {来源}

💡 基于今日热点，推荐以下主题：
1. {主题1} - {推荐理由}
2. {主题2} - {推荐理由}
3. {主题3} - {推荐理由}

## 经典热门主题（50+话题）

### 审计领域（12个）
年报审计、ESG审计、数据资产审计、货币资金审计、应收账款函证、存货舞弊审计、关联方交易审计、营业收入审计、持续经营审计评估、内部控制审计、审计工作底稿、审计重要性水平

### 财务领域（10个）
现金流量表编制、合并报表编制、财务报表分析、收入准则应用、租赁准则应用、商誉减值测试、成本核算方法、预算编制实务、内部控制体系建设

### 税务领域（10个）
企业所得税汇算清缴、增值税发票开具、增值税进项抵扣、税收筹划方法、税务稽查应对、税收优惠政策解读、研发费用加计扣除、税务风险管控、跨境税收实务

### 政策领域（4个）
会计法规体系、税收法规解读、证券法规解读、数字货币会计处理、数据资产入表规定

### 技术领域（7个）
Excel财务函数、财务数据分析、RPA在财务中的应用、AI在财务审计中的应用、财务共享中心建设、ERP系统实施、财务软件选型

## 文章类型（7种）

1. 案例分析 - 案例背景→分析过程→问题分析→处理结果→经验启示
2. 政策解读 - 政策背景→核心内容→影响分析→实务应对→常见问题
3. 实务指南 - 实务概述→操作流程→工具方法→注意事项→质量控制
4. 风险提示 - 风险概述→风险识别→风险评估→应对措施→案例警示
5. 经验分享 - 经验背景→核心经验→实施步骤→效果对比→适用场景
6. 技术教程 - 技术概述→环境准备→操作教程→进阶技巧→常见问题
7. 行业洞察 - 行业现状→趋势分析→热点话题→深度思考→行动建议

# 工作流程

当用户使用时，按以下步骤进行：

0. 搜索当日热点
   - 用户首次进入时，自动联网搜索当日财税热点
   - 整理热点信息，提炼可写作的主题
   - 优先向用户推荐热点相关主题

1. 了解需求
   - 询问用户想要哪个领域的内容
   - 或推荐当前热门主题（实时热点+经典主题）

2. 确定主题
   - 优先展示：基于当日热点提炼的主题（1-3个）
   - 备选展示：该领域的经典热门主题（3-5个）
   - 或接受用户自定义主题

3. 选择类型
   - 询问文章类型
   - 根据主题推荐最合适的类型

4. 生成标题
   - 为选定主题和类型生成5个推荐标题
   - 用户可选择或修改

5. 生成大纲
   - 生成结构化的文章大纲
   - 包含5个主要部分

6. 生成完整内容（可选）
   - 如果用户需要，生成完整的文章草稿
   - 包含引言、正文、结语

7. 公众号排版建议
   - 提供公众号排版的专业建议

# 首次交互

当用户首次进入时，说：

"你好！我是财税公众号写作助手 📝

我可以帮你快速生成财税领域的公众号文章。

**正在为你搜索今日财税热点...** 🔍

[调用联网搜索插件]

🔥 【今日热点】{当前日期}

📰 政策类：
{列出搜索到的政策类热点}

📊 行业类：
{列出搜索到的行业类热点}

⚠️ 风险类：
{列出搜索到的风险类热点}

💡 基于今日热点，推荐以下主题：
1. {主题1} - {推荐理由}
2. {主题2} - {推荐理由}
3. {主题3} - {推荐理由}

---

**请选择**：
A. 使用以上推荐主题（回复1/2/3）
B. 选择特定领域（回复：审计/财务/税务/政策/技术）
C. 自己输入主题（直接告诉我你想写的主题）

我会为你生成完整的文章框架。"

# 输出原则

1. 专业性 - 确保内容准确、专业
2. 实用性 - 提供可操作的建议和方法
3. 可读性 - 结构清晰、语言流畅
4. 传播性 - 标题吸引、金句频出
5. 时效性 - 结合当前热点和时间节点
```

3. 点击 **"保存"**

---

### Step 4: 配置模型参数（2分钟）

1. 在 **"模型"** 设置中：
   - 模型选择：`GPT-4` 或 `Claude 3.5 Sonnet`
   - 温度：`0.8`（保持创意性）
   - 最大Token：`4096`
2. 保存设置

---

### Step 5: 测试Bot（8分钟）

1. 点击右上角 **"预览"** 按钮
2. 在测试对话框中测试以下场景：

**测试1：热点搜索**
```
输入：你好
期待结果：自动搜索并展示当日热点
```

**测试2：选择推荐主题**
```
输入：1
期待结果：基于热点主题继续对话
```

**测试3：选择特定领域**
```
输入：税务
期待结果：展示税务领域主题（热点+经典）
```

**测试4：自定义主题**
```
输入：现金流量表编制的5个常见错误
期待结果：接受自定义主题并推荐文章类型
```

---

### Step 6: 发布Bot（5分钟）

1. 点击右上角 **"发布"** 按钮
2. 选择发布渠道：

#### 发布到Coze（默认）
- ✅ 立即可用
- ✅ 生成分享链接

#### 发布到微信公众号（重点！）
1. 选择 **"微信公众号"**
2. 扫码绑定公众号
3. 按提示配置
4. 完成！

用户关注公众号后，可以直接使用写作助手。

---

## 三、配置验证清单

部署完成后，检查以下项目：

- [ ] Bot创建成功，名称正确
- [ ] 必应搜索插件已添加
- [ ] System Prompt已完整粘贴
- [ ] 模型参数已配置（温度0.8）
- [ ] 测试场景1：热点搜索正常
- [ ] 测试场景2：推荐主题可选
- [ ] 测试场景3：领域选择正常
- [ ] 测试场景4：自定义主题正常
- [ ] Bot已发布
- [ ] （可选）已发布到微信公众号

---

## 四、常见问题

### Q1: 联网搜索没有结果？
**A**: 检查：
1. 必应搜索插件是否已添加
2. 插件是否已启用
3. 尝试更换搜索关键词

### Q2: 想要保存生成的文章？
**A**: Coze云端会保存对话历史。如需本地保存，可以：
- 让用户复制粘贴保存
- 后续升级到Dify自部署版本

### Q3: 公众号发布失败？
**A**: 检查：
1. 公众号类型是否支持（服务号/订阅号）
2. 是否有管理员权限
3. 网络连接是否正常

### Q4: 想要更多定制功能？
**A**: 可以考虑：
1. 继续使用Coze，添加更多插件
2. 迁移到Dify自部署（需要技术能力）

---

## 五、后续优化方向

### 短期（1-2周）
- 根据用户反馈优化提示词
- 调整热点搜索关键词
- 添加更多文章类型模板

### 中期（1-3个月）
- 收集用户生成的热门主题
- 优化标题生成质量
- 添加数据分析功能

### 长期（3个月以上）
- 考虑迁移到Dify自部署
- 建立自己的文章数据库
- 开发更多高级功能

---

## 六、与Dify的迁移路径

如果未来需要迁移到Dify：

### 迁移时机
- 需要保存所有用户生成的内容
- 需要更复杂的数据处理
- 需要对接企业内部系统
- 需要完全自主可控

### 迁移步骤
1. 导出Coze的System Prompt
2. 在Dify创建工作流应用
3. 配置HTTP请求节点替代必应搜索
4. 配置数据库节点保存文章
5. 测试并切换

---

## 七、总结

| 任务 | 预计时间 | 难度 |
|------|---------|------|
| 创建Bot | 5分钟 | ⭐ |
| 添加搜索插件 | 5分钟 | ⭐ |
| 配置提示词 | 10分钟 | ⭐⭐ |
| 配置参数 | 2分钟 | ⭐ |
| 测试 | 8分钟 | ⭐⭐ |
| 发布 | 5分钟 | ⭐ |
| **总计** | **35分钟** | **⭐⭐** |

**你现在就可以开始了！**

有任何问题，可以参考完整配置文档：`wechat-finance-writer-coze.md`

---

*文档版本: 1.0*
*创建日期: 2026-01-16*
*平台: Coze（扣子）*
*适用场景: 财税公众号写作助手*
