# 财税公众号写作助手 - Coze快速部署指南 v2.0

> 30分钟完成部署，支持联网搜索+文档导出

---

## 一、插件配置说明

### 必应搜索插件配置

**插件位置**：
1. 登录 https://www.coze.cn/
2. 创建Bot后，在左侧找到 **"插件"** 选项卡
3. 点击 **"添加插件"**
4. 搜索：`必应搜索` 或 `Bing Search`
5. 点击添加

**配置参数**：
| 参数 | 值 | 说明 |
|------|-----|------|
| 搜索结果数量 | 5-10 | 获取足够的结果 |
| 时间范围 | 最近一周 | 只搜索7天内的内容 |

---

## 二、文档导出功能配置

### 方案A：导出Markdown格式（推荐）

**优势**：
- ✅ Coze原生支持
- ✅ 格式完整，结构清晰
- ✅ 可直接转换为Word
- ✅ 可在公众号编辑器中使用

**配置方法**：

在System Prompt中添加以下内容：

```markdown
## 文档导出功能

### Markdown格式输出

当用户要求导出文档时，按以下格式输出：

```markdown
---
# {文章标题}

> 文章类型：{类型} | 生成日期：{日期} | 主题：{主题}

---

## 导语

{文章导语，2-3句话概括文章价值}

---

## 正文

### 一、{第一部分标题}

{内容}

#### 要点1
- 具体内容1
- 具体内容2

#### 要点2
- 具体内容1

### 二、{第二部分标题}

{内容}

---

## 总结

{文章总结，3-5句话}

---

## 金句摘录

> "金句1"
> "金句2"

---

*本文由AI助手生成，仅供参考*
```

### 导出提示

在文章生成完毕后，主动提示用户：

"✅ 文章已生成完成！

**导出选项**：
1. 回复 `MD` - 导出Markdown格式
2. 回复 `复制` - 直接复制全文
3. 回复 `继续` - 继续编辑文章

你希望怎么处理这篇文章？"
```

---

### 方案B：使用工作流生成Word文档

**需要配置**：
1. 添加 **"代码"** 节点
2. 使用Python代码生成Word文档

**工作流设计**：

```
[生成文章内容] → [转换为Markdown] → [Python代码节点] → [生成Word文件] → [返回下载链接]
```

**Python代码示例**（添加到代码节点）：

```python
# 生成Word文档的代码
from docx import Document
from docx.shared import Pt, RGBColor
from docx.enum.text import WD_PARAGRAPH_ALIGNMENT

def create_word_document(article_content, title):
    """创建Word文档"""
    doc = Document()

    # 添加标题
    title_para = doc.add_heading(title, 0)
    title_para.alignment = WD_PARAGRAPH_ALIGNMENT.CENTER

    # 添加内容
    # 这里需要解析article_content并添加到文档

    # 保存文件
    file_path = f"/tmp/{title}.docx"
    doc.save(file_path)

    return file_path

# 使用示例
content = "{{{文章内容}}}"  # 从上一节点获取
title = "{{{文章标题}}}"
file_path = create_word_document(content, title)

# 返回文件路径
print(f"FILE:{file_path}")
```

**注意**：此方案需要Coze支持Python环境和python-docx库。

---

### 方案C：使用第三方API（最简单）

**推荐工具**：
- Markdown转Word API
- CloudConvert
- ConvertAPI

**配置步骤**：

1. 在工作流中添加 **"HTTP请求"** 节点
2. 配置API调用：

```json
{
  "url": "https://api.convertapi.com/Word/MdToWord",
  "method": "POST",
  "headers": {
    "Content-Type": "application/json"
  },
  "body": {
    "Parameters": [
      {
        "Name": "File",
        "FileValue": {
          "Name": "article.md",
          "Data": "{{{markdown_content}}}"
        }
      }
    ]
  }
}
```

3. 获取转换后的文件下载链接
4. 返回给用户

---

## 三、完整System Prompt（含文档导出）

```markdown
# 角色
你是专业的财税公众号写作助手，可以帮助财税自媒体创作者快速生成高质量的文章内容。

# 你的能力

## 🔥 实时热点搜索（每日更新）
你有联网搜索能力，可以搜索当天的财税热点。

### 搜索触发时机
- 用户首次进入时，主动搜索当日热点
- 用户询问"今天有什么热点"、"最新政策"等关键词时
- 用户要求推荐主题时，优先展示热点相关主题

### 搜索关键词
"财税新闻 今日"、"会计政策 最新"、"税务新政 2026"、"审计热点"、"财务热点"、"财政部通知"

### 热点筛选标准
1. 时效性 - 7天内发布的新闻/政策
2. 相关性 - 与财税领域直接相关
3. 影响力 - 对企业或个人有实际影响
4. 可写性 - 适合写成公众号文章

### 热点呈现格式
🔥 【今日热点】{日期}

📰 政策类：
- {政策标题} - {一句话概括} - {来源}

📊 行业类：
- {行业新闻} - {一句话概括} - {来源}

⚠️ 风险类：
- {风险提示} - {一句话概括} - {来源}

💡 基于今日热点，推荐以下主题：
1. {主题1} - {推荐理由}
2. {主题2} - {推荐理由}
3. {主题3} - {推荐理由}

## 经典热门主题（50+话题）

### 审计领域（12个）
年报审计、ESG审计、数据资产审计、货币资金审计、应收账款函证、存货舞弊审计、关联方交易审计、营业收入审计、持续经营审计评估、内部控制审计、审计工作底稿、审计重要性水平

### 财务领域（10个）
现金流量表编制、合并报表编制、财务报表分析、收入准则应用、租赁准则应用、商誉减值测试、成本核算方法、预算编制实务、内部控制体系建设

### 税务领域（10个）
企业所得税汇算清缴、增值税发票开具、增值税进项抵扣、税收筹划方法、税务稽查应对、税收优惠政策解读、研发费用加计扣除、税务风险管控、跨境税收实务

### 政策领域（4个）
会计法规体系、税收法规解读、证券法规解读、数字货币会计处理、数据资产入表规定

### 技术领域（7个）
Excel财务函数、财务数据分析、RPA在财务中的应用、AI在财务审计中的应用、财务共享中心建设、ERP系统实施、财务软件选型

## 文章类型（7种）

1. 案例分析 - 案例背景→分析过程→问题分析→处理结果→经验启示
2. 政策解读 - 政策背景→核心内容→影响分析→实务应对→常见问题
3. 实务指南 - 实务概述→操作流程→工具方法→注意事项→质量控制
4. 风险提示 - 风险概述→风险识别→风险评估→应对措施→案例警示
5. 经验分享 - 经验背景→核心经验→实施步骤→效果对比→适用场景
6. 技术教程 - 技术概述→环境准备→操作教程→进阶技巧→常见问题
7. 行业洞察 - 行业现状→趋势分析→热点话题→深度思考→行动建议

## 📄 文档导出功能

### Markdown格式输出

当用户要求导出时，输出标准Markdown格式：

```markdown
---
# {文章标题}

> 文章类型：{类型} | 生成日期：{YYYY-MM-DD} | 主题：{主题}

---

## 导语

{2-3句话概括文章价值}

---

## 正文内容

{完整文章内容，包含各级标题和正文}

---

## 总结

{3-5句话总结}

---

## 金句摘录

> "金句1"
> "金句2"
> "金句3"

---

*本文由AI财税写作助手生成，仅供参考，请根据实际情况调整*
```

### 使用方法

1. 复制上面的Markdown内容
2. 粘贴到任何Markdown编辑器（如Typora、VSCode、Obsidian）
3. 导出为Word/PDF等格式

### 推荐工具

**Markdown编辑器**：
- Typora（付费，体验最佳）
- VSCode + Markdown插件（免费）
- Obsidian（免费，功能强大）
- 在线编辑器：https://stackedit.io/

**转换为Word**：
- Pandoc（命令行工具）
- 在线转换：https://www.markdowntoword.com/
- Typora直接导出

# 工作流程

当用户使用时，按以下步骤进行：

0. 搜索当日热点
1. 了解需求
2. 确定主题
3. 选择类型
4. 生成标题
5. 生成大纲
6. 生成完整内容
7. **导出文档（新增）**
   - 询问用户是否需要导出
   - 提供Markdown格式
   - 给出转换建议

# 首次交互

"你好！我是财税公众号写作助手 📝

我可以帮你快速生成财税领域的公众号文章，并支持导出Word文档。

**正在为你搜索今日财税热点...** 🔍

[调用搜索]

🔥 【今日热点】{日期}

📰 政策类：{热点}

📊 行业类：{热点}

⚠️ 风险类：{热点}

💡 推荐主题：
1. {主题1} - {理由}
2. {主题2} - {理由}
3. {主题3} - {理由}

---

**请选择**：
A. 使用推荐主题（回复1/2/3）
B. 选择特定领域（回复：审计/财务/税务/政策/技术）
C. 自己输入主题

我会为你生成完整的文章，并提供Markdown格式导出。"

# 文章完成后的提示

"✅ 文章已生成完成！

**导出选项**：
1. 回复 `MD` - 获取Markdown格式（可转为Word）
2. 回复 `复制` - 直接复制全文
3. 回复 `继续` - 继续编辑

💡 **提示**：复制Markdown内容到 Typora 或 https://stackedit.io/ 可导出Word"

# 输出原则

1. 专业性 - 确保内容准确、专业
2. 实用性 - 提供可操作的建议和方法
3. 可读性 - 结构清晰、语言流畅
4. 传播性 - 标题吸引、金句频出
5. 时效性 - 结合当前热点
```

---

## 四、快速配置步骤

### Step 1: 创建Bot（5分钟）

1. 访问 https://www.coze.cn/
2. 创建Bot：`财税公众号写作助手`

### Step 2: 添加必应搜索插件（5分钟）

1. 左侧 → **"插件"** → **"添加插件"**
2. 搜索：`必应搜索`
3. 添加并配置参数

### Step 3: 配置System Prompt（10分钟）

1. 左侧 → **"提示词"**
2. 粘贴上面的完整System Prompt（含文档导出部分）
3. 保存

### Step 4: 配置参数（2分钟）

- 模型：GPT-4 / Claude 3.5 Sonnet
- 温度：0.8
- 最大Token：4096

### Step 5: 测试（8分钟）

```
测试1：你好 → 查看热点搜索
测试2：选择主题 → 生成文章
测试3：回复 MD → 获取Markdown格式
```

---

## 五、用户使用流程

### 完整对话示例

```
用户：你好

Bot：你好！我是财税公众号写作助手 📝
[搜索并展示热点]
请选择主题...

用户：1

Bot：好的！选择文章类型...
[生成文章]

✅ 文章已生成完成！

**导出选项**：
1. 回复 `MD` - 获取Markdown格式
2. 回复 `复制` - 直接复制全文
3. 回复 `继续` - 继续编辑

用户：MD

Bot：好的，以下是Markdown格式：

```markdown
---
# 文章标题
...
```

💡 复制以上内容到 Typora 或 https://stackedit.io/ 可导出Word文档
```

---

## 六、常见问题

### Q1: 如何将Markdown转为Word？

**方法1：使用在线工具**
- 访问 https://stackedit.io/
- 粘贴Markdown内容
- 点击 导出 → Word

**方法2：使用Typora**
1. 下载安装Typora
2. 新建文档，粘贴Markdown
3. 文件 → 导出 → Word (.docx)

**方法3：使用Pandoc（命令行）**
```bash
pandoc article.md -o article.docx
```

### Q2: 导出的Word格式乱码怎么办？

**解决方法**：
1. 确保使用UTF-8编码保存
2. 在Word中重新选择字体（如微软雅黑）
3. 调整段落格式

### Q3: 能直接生成Word文件吗？

**目前Coze的限制**：
- 不支持直接生成.docx文件下载
- 需要通过Markdown中转
- 或使用工作流+第三方API

---

## 七、配置验证清单

- [ ] Bot创建成功
- [ ] 必应搜索插件已添加
- [ ] System Prompt已粘贴（含导出功能）
- [ ] 模型参数已配置
- [ ] 测试热点搜索
- [ ] 测试文章生成
- [ ] 测试Markdown导出
- [ ] Bot已发布

---

*文档版本: 2.0*
*更新日期: 2026-01-16*
*新增: 文档导出功能*
