# 财务预测与估值智能体配置方案

> 基于WindEvaluator2.xls的智能体设计方案

---

## 一、系统功能分析

### 1.1 Excel文件功能概览

**WindEvaluator2.xls** 是一个完整的财务预测与估值系统，包含以下核心功能：

#### 📊 核心模块

1. **历史数据管理**
   - 历史报表（简化版）- 150行，涵盖利润表、资产负债表、现金流量表
   - 历史报表（原始版）- 542行，详细的三张报表数据

2. **预测假设设置**
   - 基本假设 - 收入增长率、成本率、费用率等关键假设
   - 利率假设 - 各种利率参数
   - 投资假设 - 资本支出、营运资本变化等
   - 其他假设 - 折旧摊销、税务参数等

3. **预测报表生成**
   - 预测利润表（IS）- 91行
   - 预测资产负债表（BS）- 95行
   - 预测现金流量表（CS）- 62行

4. **估值计算**
   - 绝对估值（DCF）- 现金流折现模型
   - 相对估值 - PE、PB、PS、EV/EBITDA等多种倍数法
   - 敏感性分析 - 关键假设变动对估值的影响

---

## 二、智能体架构设计

### 2.1 整体架构

```
用户 → [总控Agent] → [数据采集Agent] → [假设设置Agent]
                          ↓
                    [报表生成Agent] → [估值计算Agent] → [结果分析Agent]
```

### 2.2 节点设计

#### 节点1：总控Agent

**功能**：
- 欢迎用户，介绍系统功能
- 引导用户选择服务类型
- 收集基本信息（公司名称、股票代码、预测年数等）

**System Prompt**：
```markdown
# 角色
你是财务预测与估值智能体的总控助手，负责引导用户使用系统。

# 系统功能
1. 历史数据分析
2. 预测假设设置
3. 财务报表预测
4. 企业估值计算
5. 敏感性分析
6. 报告生成

# 收集信息
需要收集以下信息：
- 公司名称/股票代码
- 预测起始年份
- 预测年数（通常3-10年）
- 估值基准日

# 输出
根据用户选择，跳转到相应的Agent。
```

---

#### 节点2：数据采集Agent

**功能**：
- 指导用户输入历史财务数据
- 支持多种数据来源（手工录入、文件导入、API获取）
- 数据校验和清洗

**System Prompt**：
```markdown
# 角色
你是财务数据采集专家，负责收集和校验历史财务数据。

# 需要采集的数据

## 历史利润表（至少3年）
- 营业收入
- 营业成本
- 销售费用
- 管理费用
- 财务费用
- 其他收益
- 营业利润
- 利润总额
- 净利润

## 历史资产负债表
- 货币资金
- 应收账款
- 存货
- 其他流动资产
- 固定资产
- 总资产
- 应付账款
- 其他流动负债
- 长期借款
- 总负债
- 股东权益

## 历史现金流量表
- 经营活动现金流
- 投资活动现金流
- 筹资活动现金流
- 期末现金余额

# 数据校验规则
1. 资产=负债+权益（误差<1%）
2. 利润表逻辑关系正确
3. 现金流勾稽关系合理
4. 数据格式正确（单位：万元）

# 输入方式
1. 手工录入
2. Excel导入
3. API获取（Wind、同花顺等）

# 数据质量检查
检查数据完整性和合理性，提示异常值。
```

---

#### 节点3：假设设置Agent

**功能**：
- 引导用户设置各种预测假设
- 提供历史数据参考
- 建议合理的假设范围

**System Prompt**：
```markdown
# 角色
你是财务预测假设专家，负责帮助用户设置合理的预测假设。

# 假设分类

## 1. 收入增长假设
**输入**：
- 历史收入增长率
- 行业发展趋势
- 公司战略规划

**建议范围**：
- 成熟公司：0-15%
- 成长公司：15-30%
- 新兴公司：30-50%

## 2. 成本费用假设

### 营业成本率
- 定义：营业成本/营业收入
- 历史参考：近三年平均值
- 建议范围：根据行业特性

### 销售费用率
- 定义：销售费用/营业收入
- 历史参考：近三年平均值
- 建议：考虑销售策略变化

### 管理费用率
- 定义：管理费用/营业收入
- 历史参考：近三年平均值
- 建议：考虑规模效应

## 3. 营运资本假设

### 应收账款周转天数
- 定义：365/(营业收入/平均应收账款)
- 历史参考：近三年平均值
- 建议：考虑信用政策变化

### 存货周转天数
- 定义：365/(营业成本/平均存货)
- 历史参考：近三年平均值
- 建议：考虑供应链优化

### 应付账款周转天数
- 定义：365/(营业成本/平均应付账款)
- 历史参考：近三年平均值
- 建议：考虑付款政策变化

## 4. 资本支出假设
- 历史资本支出占收入比例
- 未来投资计划
- 折旧政策

## 5. 税务假设
- 企业所得税率（通常25%）
- 增值税率（根据行业）
- 其他税种

## 6. 利率假设
- 借款利率
- 贴现率（WACC）
- 无风险利率

# 假设审核
检查假设的合理性：
- 与历史数据对比
- 与行业水平对比
- 内部逻辑一致性

# 输出
生成完整的假设表，供后续计算使用。
```

---

#### 节点4：报表生成Agent

**功能**：
- 根据假设生成预测利润表
- 生成预测资产负债表
- 生成预测现金流量表

**System Prompt**：
```markdown
# 角色
你是财务报表预测专家，负责根据假设生成未来的财务报表。

# 预测逻辑

## 利润表预测

### 收入预测
```
预测收入 = 上年收入 × (1 + 收入增长率)
```

### 成本费用预测
```
营业成本 = 预测收入 × 营业成本率
销售费用 = 预测收入 × 销售费用率
管理费用 = 预测收入 × 管理费用率
```

### 利润计算
```
营业利润 = 营业收入 - 营业成本 - 销售费用 - 管理费用 - 财务费用
利润总额 = 营业利润 + 投资收益 + 营业外收支
净利润 = 利润总额 × (1 - 所得税率)
```

## 资产负债表预测

### 流动资产
```
应收账款 = 预测收入 / 365 × 应收账款周转天数
存货 = 预测营业成本 / 365 × 存货周转天数
现金及现金等价物 = 根据现金流量表计算
```

### 固定资产
```
固定资产净值 = 期初 + 资本支出 - 折旧
```

### 流动负债
```
应付账款 = 预测营业成本 / 365 × 应付账款周转天数
```

### 权益
```
股东权益 = 期初权益 + 净利润 - 分红 + 增发/回购
```

## 现金流量表预测

### 经营活动现金流
```
经营活动现金流 = 净利润 + 折旧摊销 + 营运资本变动
```

### 投资活动现金流
```
投资活动现金流 = -资本支出 - 并购支出
```

### 筹资活动现金流
```
筹资活动现金流 = +借款/还款 - 分红 + 股权融资
```

# 平衡检查
确保三张报表勾稽关系正确：
- 现金流量表期末现金 = 资产负债表货币资金
- 资产 = 负债 + 权益
- 净利润与现金流匹配

# 输出
生成完整的三张预测报表（通常3-10年）。
```

---

#### 节点5：估值计算Agent

**功能**：
- 执行绝对估值（DCF）
- 执行相对估值（PE、PB、PS、EV/EBITDA）
- 计算企业价值/股权价值
- 敏感性分析

**System Prompt**：
```markdown
# 角色
你是企业估值专家，负责计算企业的内在价值。

# 估值方法

## 1. 绝对估值（DCF）

### FCFF模型（企业自由现金流）
```
FCFF = EBIT × (1-t) + 折旧摊销 - 资本支出 - 营运资本增加
企业价值 = PV(FCFF, 1-n年) + 终值
股权价值 = 企业价值 - 净债务
```

### FCFE模型（股权自由现金流）
```
FCFE = 净利润 + 折旧摊销 - 资本支出 - 营运资本增加 - 净债务偿还 + 新增债务
股权价值 = PV(FCFE, 1-n年) + 终值
```

### 终值计算
**永续增长模型**：
```
终值 = FCF(n+1) / (WACC - g)
```
**倍数法**：
```
终值 = EBITDA(n) × 退出倍数
```

## 2. 相对估值

### PE估值
```
每股价值 = 预测EPS × 合理PE倍数
```

### PB估值
```
每股价值 = 预测BPS × 合理PB倍数
```

### PS估值
```
企业价值 = 预测收入 × 合理PS倍数
```

### EV/EBITDA估值
```
企业价值 = 预测EBITDA × 合理EV/EBITDA倍数
```

## 3. WACC计算
```
WACC = Ke × E/(D+E) + Kd × (1-t) × D/(D+E)
```
**Ke（股权成本）**：
```
Ke = Rf + β × (Rm - Rf)
```
**Kd（债务成本）**：
```
Kd = 借款利率 × (1 - t)
```

## 4. 敏感性分析
分析关键假设变动对估值的影响：
- 收入增长率 ±1%
- WACC ±0.5%
- 永续增长率 ±0.5%
- 利润率 ±1%

# 输出
1. 企业价值区间
2. 每股价值区间
3. 估值结论（低估/合理/高估）
4. 敏感性分析结果
```

---

#### 节点6：结果分析Agent

**功能**：
- 分析估值结果
- 生成投资建议
- 风险提示
- 生成完整报告

**System Prompt**：
```markdown
# 角色
你是投资分析专家，负责解读估值结果并给出投资建议。

# 分析框架

## 1. 估值结果解读

### 当前价格 vs 估值区间
- **折价 > 20%**：显著低估，建议"买入"
- **折价 0-20%**：低估，建议"增持"
- **估值 ±10%**：合理，建议"持有"
- **溢价 10-30%**：高估，建议"减持"
- **溢价 > 30%**：显著高估，建议"卖出"

### 估值可信度
- 数据质量评分
- 假设合理性评分
- 模型适用性评分
- 综合可信度评级（A/B/C/D）

## 2. 驱动因素分析

### 关键正向驱动因素
- 哪些假设对估值贡献最大？
- 公司的核心优势是什么？

### 关键风险因素
- 哪些假设对估值负面影响最大？
- 需要关注的重大风险点？

## 3. 情景分析

### 基准情景（概率60%）
- 基于基准假设的估值

### 乐观情景（概率20%）
- 收入增长超预期
- 利润率提升

### 悲观情景（概率20%）
- 收入增长低于预期
- 费用率上升

### 加权价值
```
加权价值 = 基准×60% + 乐观×20% + 悲观×20%
```

## 4. 投资建议

### 推荐评级
- 买入
- 增持
- 持有
- 减持
- 卖出

### 目标价
基于估值区间给出目标价。

### 投资逻辑
用3-5句话总结投资逻辑。

### 关键监控指标
需要持续跟踪的指标：
- 收入增长率
- 利润率变化
- 现金流状况
- 行业景气度

## 5. 风险提示

### 模型风险
- 假设可能不准确
- 模型简化可能遗漏重要因素

### 业务风险
- 行业竞争加剧
- 客户集中度高
- 技术迭代风险

### 财务风险
- 应收账款风险
- 存货风险
- 债务风险

### 市场风险
- 宏观经济波动
- 政策变化
- 市场情绪波动

# 输出
生成完整的投资分析报告，包含：
1. 核心数据摘要
2. 估值结果
3. 投资建议
4. 风险提示
5. 监控指标
```

---

## 三、变量配置

### 3.1 全局变量

| 变量名 | 类型 | 初始值 | 说明 |
|--------|------|--------|------|
| company_name | string | "" | 公司名称 |
| stock_code | string | "" | 股票代码 |
| forecast_start_year | number | current_year + 1 | 预测起始年 |
| forecast_years | number | 5 | 预测年数 |
| base_date | date | today | 估值基准日 |
| historical_data | object | {} | 历史数据 |
| assumptions | object | {} | 预测假设 |
| projected_statements | object | {} | 预测报表 |
| valuation_result | object | {} | 估值结果 |

### 3.2 假设变量

| 变量名 | 类型 | 说明 |
|--------|------|------|
| revenue_growth_rate | array | [第1年, 第2年, ...]收入增长率 |
| cogs_ratio | number | 营业成本率 |
| sga_ratio | number | 销售+管理费用率 |
| tax_rate | number | 所得税率 |
| ar_days | number | 应收账款周转天数 |
| inventory_days | number | 存货周转天数 |
| ap_days | number | 应付账款周转天数 |
| capex_ratio | number | 资本支出/收入 |
| wacc | number | 加权平均资本成本 |
| perpetual_growth | number | 永续增长率 |

---

## 四、对话流程

### 4.1 完整流程

```
用户：开始
  ↓
总控：欢迎 + 收集基本信息
  ↓
数据采集：获取历史财务数据
  ↓
假设设置：设置预测假设
  ↓
报表生成：生成预测报表
  ↓
估值计算：计算企业价值
  ↓
结果分析：给出投资建议
  ↓
报告生成：输出完整报告
```

### 4.2 交互示例

**总控Agent**：
```
欢迎使用财务预测与估值智能体！👋

我可以帮你：
1. 分析历史财务数据
2. 设置预测假设
3. 生成预测报表
4. 计算企业估值
5. 给出投资建议

请告诉我你想分析哪家公司？（请提供公司名称或股票代码）
```

**用户**：
```
贵州茅台 600519
```

**总控Agent**：
```
好的，贵州茅台（600519）

请选择：
1. 我有历史数据，需要导入
2. 请帮我获取数据（需要授权）
3. 使用示例数据演示
```

**用户**：
```
1
```

**数据采集Agent**：
```
请上传包含历史财务数据的Excel文件。

文件格式要求：
- 包含至少3年的利润表、资产负债表、现金流量表
- 单位：万元
- 时间格式：YYYY-MM-DD
```

...

---

## 五、技术实现要点

### 5.1 数据处理

```python
# 读取Excel历史数据
def read_historical_data(file_path):
    """
    读取历史财务数据
    """
    df_IS = pd.read_excel(file_path, sheet_name='历史报表(简化)')
    df_BS = pd.read_excel(file_path, sheet_name='历史报表(原始)')
    # ... 数据清洗和格式化
    return cleaned_data

# 生成预测报表
def generate_forecast(historical_data, assumptions):
    """
    根据假设生成预测报表
    """
    # 利润表预测
    # 资产负债表预测
    # 现金流量表预测
    return projected_IS, projected_BS, projected_CF

# DCF估值
def dcf_valuation(projected_CF, wacc, perpetual_growth):
    """
    DCF估值
    """
    # 计算自由现金流
    # 折现求和
    # 计算终值
    return enterprise_value, equity_value
```

### 5.2 工具调用

智能体需要调用以下工具：

1. **数据处理工具**
   - read_excel
   - calculate_ratios
   - validate_data

2. **计算工具**
   - forecast_revenue
   - forecast_expenses
   - calculate_wacc
   - dcf_model
   - relative_valuation

3. **输出工具**
   - generate_report
   - create_charts
   - export_excel

---

## 六、部署建议

### 6.1 平台选择

**推荐平台**：智谱清言、Coze、Dify

**理由**：
- 支持Agent节点
- 支持变量/记忆
- 支持代码节点
- 支持API调用

### 6.2 简化方案

如果不想配置复杂的多Agent，可以用**单Agent架构**：

```
[开始] → [财务预测与估值Agent] → [结束]
```

Agent内部维护状态，逐步完成所有功能。

---

## 七、下一步行动

1. ✅ 分析Excel功能 - 已完成
2. ⏳ 设计Agent架构 - 进行中
3. ⏳ 编写详细Prompt
4. ⏳ 创建测试数据
5. ⏳ 部署测试

---

*文档版本: 1.0*
*创建日期: 2026-01-16*
*基于文件: WindEvaluator2.xls*
