---
name: finance-content-generator
description: 财税审计内容生成器 - 快速生成专业财税公众号文章，支持多种文章类型和主题
---

# 财税审计内容生成器

## 触发方式

当用户说类似以下内容时触发：
- "帮我写一篇财税文章"
- "生成一篇关于XX的审计文章"
- "我要写公众号内容"
- "写一篇政策解读"
- "/fin" 开头的命令

---

## 功能概览

| 功能 | 命令 | 说明 |
|------|------|------|
| **交互模式** | `/fin` | 进入交互式内容生成对话 |
| **生成文章** | `/fin-article {topic}` | 生成财税审计文章（公众号格式） |
| **完整文章** | `/fin-full {topic}` | 生成完整版文章 |
| **案例分析** | `/fin-case {topic}` | 生成案例分析类文章 |
| **政策解读** | `/fin-policy {topic}` | 生成政策解读类文章 |
| **风险提示** | `/fin-risk {topic}` | 生成风险提示类文章 |
| **经验分享** | `/fin-share {topic}` | 生成经验分享类文章 |
| **实务指南** | `/fin-guide {topic}` | 生成实务指南类文章 |
| **技术教程** | `/fin-tutorial {topic}` | 生成技术教程类文章 |
| **行业洞察** | `/fin-insight {topic}` | 生成行业洞察类文章 |
| **查看主题** | `/fin-topics` | 查看所有热门文章主题 |
| **按领域查看** | `/fin-audit` `/fin-finance` `/fin-tax` 等 | 查看特定领域热门主题 |
| **生成大纲** | `/fin-outline {topic}` | 生成文章大纲 |
| **生成标题** | `/fin-titles {topic}` | 生成文章标题选项 |
| **生成配图** | `/fin-images {article_path}` | 为财税文章生成配图 |

---

## 支持的文章类型

| 类型 | 适用场景 | 示例主题 |
|------|----------|----------|
| 案例分析 | 真实案例解读 | "上市公司财务造假案例" |
| 政策解读 | 新政影响分析 | "新《公司法》解读" |
| 风险提示 | 合规风险警示 | "金税四期风险点" |
| 经验分享 | 实务经验总结 | "审计新人避坑指南" |
| 实务指南 | 操作指南 | "小公司内控制度" |
| 技术教程 | 专业技能教学 | "Excel财务建模" |
| 行业洞察 | 趋势分析 | "2024财税行业趋势" |

---

## 支持的专业领域

| 领域 | 命令 | 热门主题示例 |
|------|------|--------------|
| 审计 | `/fin-audit` | 财务造假、内控审计、尽职调查 |
| 财务 | `/fin-finance` | 报表分析、成本控制、预算管理 |
| 税务 | `/fin-tax` | 个税汇算、税务筹划、发票管理 |
| 政策 | `/fin-policy-topics` | 公司法、税法、会计准则 |
| 技术 | `/fin-tech` | Excel、Python、财务系统 |

---

## 编辑部评审工作流

完整的多角色评审流程：

| 角色 | 命令 | 评审视角 |
|------|------|----------|
| **完整流程** | `/fin-review {topic}` | 全流程评审 |
| **架构师** | `/fin-review-architect` | 流量+转化 |
| **主笔管** | `/fin-review-writer` | 结构+深度 |
| **毒舌编辑** | `/fin-review-acid` | 找错+质量 |
| **改稿人** | `/fin-review-ghost` | 表达+可读性 |
| **包装人** | `/fin-review-pack` | 爆款+变现 |

---

## 配图生成

| 命令 | 说明 |
|------|------|
| `/fin-images {path}` | 财税文章配图 |
| `/fin-images-tax {path}` | 税务文章配图 |
| `/fin-images-audit {path}` | 审计文章配图 |
| `/fin-images-finance {path}` | 财务文章配图 |
| `/fin-images-policy {path}` | 政策解读配图 |
| `/fin-images-risk {path}` | 风险提示配图 |

---

## 使用流程

### 方式一：直接生成文章

```
用户: /fin-article 小公司财务混乱
```

### 方式二：先查看热门主题

```
用户: /fin-topics
→ 获取热门主题列表

用户: /fin-article 新《公司法》实施影响
```

### 方式三：完整创作流程

```
1. /fin-outline {主题}      # 生成大纲
2. /fin-titles {主题}       # 生成标题选项
3. /fin-article {主题}      # 生成文章
4. /fin-images {文章路径}   # 生成配图
```

---

## 文章格式特点

- **公众号格式**：适配微信公众号编辑器
- **专业准确**：基于财税专业知识库
- **实用导向**：注重实务操作和落地建议
- **风格多样**：支持严肃干货和趣味科普

---

## 文件结构

```
finance-content-generator/
├── SKILL.md                           # 本文件
├── finance-content-skill.json         # 命令配置
├── finance-content-generator.js       # 内容生成脚本
├── finance-image-generator.cjs        # 配图生成脚本
└── editorial-workflow.js              # 编辑部评审脚本
```
