# Comparable Companies Guide

## Peer Selection

- Match business model, end market, and revenue mix.
- Align scale and growth profile when possible.
- Prefer publicly traded companies with reliable disclosures.
- Use a mix of direct and adjacent peers; justify inclusions.

## Core Fields

- Company, ticker, headquarters, description
- Market cap, enterprise value, net debt
- LTM and next-year revenue, EBITDA, EBIT, EPS
- Growth (1Y, 3Y CAGR), margins (EBITDA, EBIT)
- Multiples: EV/Revenue, EV/EBITDA, P/E, EV/FCF

## Adjustments

- Normalize for one-time items and accounting differences.
- Flag outliers and provide a reason for exclusion if needed.
- Use median and interquartile range for summary stats.

## Output Expectations

- Comps table with a summary row (median, mean, quartiles)
- Brief narrative on peer set rationale and key takeaways
