# Fin Intel Hub 金融智能中心

OpenClaw 金融数据智能分析技能 - 支持全球市场包括美国、中国、香港、台湾、日本和韩国。

🇨🇳 简体中文 | 🇭🇰 繁體中文 (香港/台灣)

---

## 功能特点 / 功能特點

### 🇨🇳 简体中文

- **SEC 财报** - 获取 10-K、10-Q、8-K 财报文件
- **市场数据** - 股票价格、收益、基本面数据
- **亚洲市场** - 香港、东京、台湾、韩国、上海、深圳交易所
- **指数与期货** - 15+ 全球指数、商品期货
- **加密货币链上** - DeFi TVL、交易所资金流、Gas 费用
- **新闻情绪** - 财经新闻情绪分析
- **宏观数据** - 美联储利率、CPI、失业率

### 🇭🇰 繁體中文 (香港)

- **SEC 財報** - 獲取 10-K、10-Q、8-K 財報文件
- **市場數據** - 股票價格、收益、基本面數據
- **亞洲市場** - 香港、東京、台灣、韓國、上海、深圳交易所
- **指數與期貨** - 15+ 全球指數、商品期貨
- **加密貨幣鏈上** - DeFi TVL、交易所資金流、Gas 費用
- **新聞情緒** - 財經新聞情緒分析
- **宏觀數據** - 美聯儲利率、CPI、失業率

---

## 快速开始 / 快速開始

### 🇨🇳 简体中文

#### 方法 A：通过 Clawhub 安装（推荐）
```bash
npx clawhub install fin-intel-hub
```

#### 方法 B：手动安装
克隆或下载到 OpenClaw 技能目录：
```bash
git clone https://github.com/xuan622/fin-intel-hub.git ~/.openclaw/skills/fin-intel-hub
```

或下载并解压到 `~/.openclaw/skills/fin-intel-hub/`。

**无需 API 密钥即可使用！**

### 🇭🇰 繁體中文 (香港)

#### 方法 A：通過 Clawhub 安裝（推薦）
```bash
npx clawhub install fin-intel-hub
```

#### 方法 B：手動安裝
克隆或下載到 OpenClaw 技能目錄：
```bash
git clone https://github.com/xuan622/fin-intel-hub.git ~/.openclaw/skills/fin-intel-hub
```

或下載並解壓到 `~/.openclaw/skills/fin-intel-hub/`。

**無需 API 密鑰即可使用！**

---

## 使用示例 / 使用示例

### 股票市场 / 股票市場

**简体中文:**
```python
from scripts.yahoo_finance import get_hong_kong_stock, get_shanghai_stock

# 香港 - 腾讯 (0700.HK)
prices = get_hong_kong_stock("0700", period="1y")

# 上海 - 贵州茅台 (600519)
prices = get_shanghai_stock("600519")
```

**繁體中文 (香港):**
```python
from scripts.yahoo_finance import get_hong_kong_stock, get_taiwan_stock

# 香港 - 騰訊 (0700.HK)
prices = get_hong_kong_stock("0700", period="1y")

# 台灣 - 台積電 (2330.TW)
prices = get_taiwan_stock("2330")
```

---

## 支持的市场 / 支持的市場

### 🇨🇳 简体中文

| 市场 | 代码示例 | 交易所 |
|------|----------|--------|
| 美国 | AAPL, TSLA | NYSE/NASDAQ |
| 香港 | 0700, 3690 | 港交所 |
| 上海 | 600519, 000001 | 上交所/深交所 |
| 东京 | 7203, 6758 | 东京证券交易所 |
| 台湾 | 2330, 2317 | 台湾证券交易所 |
| 韩国 | 005930, 035420 | 韩国交易所 |

### 🇭🇰 繁體中文 (香港)

| 市場 | 代碼示例 | 交易所 |
|------|----------|--------|
| 美國 | AAPL, TSLA | NYSE/NASDAQ |
| 香港 | 0700, 3690 | 港交所 |
| 上海 | 600519, 000001 | 上交所/深交所 |
| 東京 | 7203, 6758 | 東京證券交易所 |
| 台灣 | 2330, 2317 | 台灣證券交易所 |
| 韓國 | 005930, 035420 | 韓國交易所 |

---

## 免责声明 / 免責聲明

### 🇨🇳 简体中文

**重要提示：在使用本技能前请仔细阅读此免责声明**

- **本技能仅供信息和教育目的使用**
- **不构成投资建议** - 作者不是金融顾问
- **数据准确性** - 数据来自第三方 API，可能存在延迟或错误
- **投资风险** - 投资涉及重大风险，可能导致本金损失
- **请咨询专业金融顾问** - 本技能不能替代专业建议
- **使用风险自负** - 作者不对任何损失承担责任

**使用本技能即表示您同意此免责声明。**

### 🇭🇰 繁體中文 (香港)

**重要提示：在使用本技能前請仔細閱讀此免責聲明**

- **本技能僅供信息和教育目的使用**
- **不構成投資建議** - 作者不是金融顧問
- **數據準確性** - 數據來自第三方 API，可能存在延遲或錯誤
- **投資風險** - 投資涉及重大風險，可能導致本金損失
- **請咨詢專業金融顧問** - 本技能不能替代專業建議
- **使用風險自負** - 作者不對任何損失承擔責任

**使用本技能即表示您同意此免責聲明。**

---

## GitHub 仓库 / GitHub 倉庫

🔗 **https://github.com/xuan622/fin-intel-hub**

---

**Built with 🏗️ by David (CTO, Boring Life)**
**由 David 打造 (Boring Life CTO)**
