---
name: fin-cog
description: "Wall Street-grade analysis, accessible globally. Deep financial reasoning powered by #1 on DeepResearch Bench (Feb 2026) + SOTA financial models — stock analysis, valuation models, portfolio optimization, earnings breakdowns, financial statements, tax planning, and investment research. From raw tickers to boardroom-ready deliverables in one request."
metadata:
  openclaw:
    emoji: "💰"
author: CellCog
dependencies: [cellcog]
---

# Fin Cog - Wall Street-Grade Analysis, Accessible Globally

**Wall Street-grade analysis, accessible globally.** Deep financial reasoning powered by #1 on DeepResearch Bench (Feb 2026) + SOTA financial models.

The best financial analysis has always lived behind Bloomberg terminals, institutional research desks, and $500/hour consultants. CellCog brings that same depth — stock analysis, valuation models, portfolio optimization, earnings breakdowns — to anyone with a prompt. From raw tickers to boardroom-ready deliverables in one request.

---

## Prerequisites

This skill requires the `cellcog` skill for SDK setup and API calls.

```bash
clawhub install cellcog
```

**Read the cellcog skill first** for SDK setup. This skill shows you what's possible.

**Quick pattern (v1.0+):**
```python
# Fire-and-forget - returns immediately
result = client.create_chat(
    prompt="[your financial analysis request]",
    notify_session_key="agent:main:main",
    task_label="financial-analysis",
    chat_mode="agent team"  # Agent team for deep financial reasoning
)
# Daemon notifies you when complete - do NOT poll
```

---

## What Financial Work You Can Do

### Stock & Equity Analysis

Deep dives into public companies:

- **Company Analysis**: "Analyze NVIDIA — revenue trends, margins, competitive moat, and forward guidance"
- **Earnings Breakdowns**: "Break down Apple's Q4 2025 earnings — beat/miss, segment performance, management commentary"
- **Valuation Models**: "Build a DCF model for Microsoft with bear, base, and bull scenarios"
- **Peer Comparisons**: "Compare semiconductor stocks — NVDA, AMD, INTC, TSM — on valuation, growth, and profitability metrics"
- **Technical Analysis**: "Analyze Tesla's price action — key support/resistance levels, moving averages, and volume trends"

**Example prompt:**
> "Create a comprehensive stock analysis for Palantir (PLTR):
> 
> Cover:
> - Business model and revenue breakdown (government vs commercial)
> - Last 4 quarters earnings performance
> - Key financial metrics (P/E, P/S, FCF margin, revenue growth)
> - Competitive positioning vs Snowflake, Databricks, C3.ai
> - Bull and bear thesis
> - Valuation assessment
> 
> Deliver as an interactive HTML report with charts."

### Portfolio Analysis & Optimization

Manage and optimize investments:

- **Portfolio Review**: "Analyze my portfolio: 40% AAPL, 20% MSFT, 15% GOOGL, 15% AMZN, 10% TSLA — diversification, risk, and recommendations"
- **Asset Allocation**: "Design an optimal portfolio for a 35-year-old with $200K, moderate risk tolerance"
- **Risk Assessment**: "Calculate the Sharpe ratio, beta, and maximum drawdown for this portfolio over the last 3 years"
- **Rebalancing**: "My portfolio drifted from target — recommend rebalancing trades to minimize tax impact"

### Financial Modeling

Build professional financial models:

- **DCF Models**: "Build a discounted cash flow model for Shopify with sensitivity analysis on growth and discount rate"
- **Startup Financial Models**: "Create a 3-year financial projection for a B2B SaaS with $50K MRR growing 15% monthly"
- **LBO Models**: "Model a leveraged buyout scenario for a $100M revenue company at 8x EBITDA"
- **Scenario Analysis**: "Create a 3-scenario model (recession, baseline, boom) for a retail REIT portfolio"

### Financial Documents & Reports

Professional financial deliverables:

- **Investment Memos**: "Write an investment memo recommending a position in CrowdStrike"
- **Quarterly Reports**: "Create a quarterly financial report for my small business"
- **Financial Statements**: "Generate pro forma financial statements for a startup fundraise"
- **Tax Planning**: "Analyze tax optimization strategies for a freelancer earning $150K with $30K in capital gains"

### Personal Finance

Everyday financial planning:

- **Retirement Planning**: "How much do I need to save monthly to retire at 55 with $2M? I'm 30, saving $2K/month currently"
- **Mortgage Analysis**: "Compare a 15-year vs 30-year mortgage on a $500K home with 20% down at current rates"
- **Debt Payoff**: "Create a debt payoff plan: $15K student loans at 5%, $8K credit card at 22%, $25K car loan at 6%"
- **Budget Optimization**: "Analyze my spending breakdown and recommend where to cut to save $1,000/month more"

---

## Output Formats

CellCog delivers financial analysis in multiple formats:

| Format | Best For |
|--------|----------|
| **Interactive HTML Dashboard** | Explorable charts, drill-down analysis, live data presentation |
| **PDF Report** | Shareable, printable investment memos and reports |
| **XLSX Spreadsheet** | Editable financial models, projections, calculations |
| **Markdown** | Quick analysis for integration into your docs |

Specify your preferred format in the prompt:
- "Deliver as an interactive HTML report with charts"
- "Create a PDF investment memo"
- "Build this as an editable Excel model"

---

## Chat Mode for Finance

| Scenario | Recommended Mode |
|----------|------------------|
| Quick lookups, single stock metrics, basic calculations | `"agent"` |
| Deep analysis, valuation models, multi-company comparisons, investment research | `"agent team"` |

**Use `"agent team"` for most financial analysis.** Financial work demands deep reasoning, data cross-referencing, and multi-source synthesis. Agent team mode delivers the depth that serious financial analysis requires.

**Use `"agent"` for quick financial lookups** — current stock price, simple calculations, or basic metric checks.

---

## Example Prompts

**Comprehensive stock analysis:**
> "Create a full investment analysis for AMD:
> 
> 1. Business Overview — segments, revenue mix, competitive positioning
> 2. Financial Performance — last 8 quarters revenue, margins, EPS trends
> 3. Valuation — P/E, P/S, PEG vs peers (NVDA, INTC, QCOM)
> 4. Growth Catalysts — AI/datacenter, gaming, embedded
> 5. Risk Factors — competition, cyclicality, customer concentration
> 6. Bull/Bear/Base price targets
> 
> Interactive HTML report with comparison charts."

**Financial model:**
> "Build a startup financial model:
> 
> Business: B2B SaaS, project management tool
> Current: $30K MRR, 200 customers, $150 ARPU
> Growth: 12% MoM for 12 months, then 8% for next 12
> Team: 8 people now, hiring 4 in next year
> Expenses: $180K/month burn rate
> 
> Create a 24-month projection showing:
> - Revenue forecast with cohort analysis
> - Expense breakdown and hiring plan
> - Cash flow and runway
> - Unit economics (CAC, LTV, payback period)
> - Break-even analysis
> 
> Deliver as Excel spreadsheet with charts."

**Personal finance:**
> "I'm 28, earning $120K/year in San Francisco. I want to:
> 1. Max out 401K contributions
> 2. Build a 6-month emergency fund ($30K)
> 3. Save for a house down payment ($100K in 5 years)
> 4. Start investing in index funds
> 
> Create a detailed monthly financial plan that shows how to prioritize these goals with my take-home pay after taxes. Include a timeline and visual roadmap."

**Earnings analysis:**
> "Break down Tesla's most recent quarterly earnings:
> 
> - Revenue vs estimates (beat/miss by how much?)
> - Automotive margins — trend over last 4 quarters
> - Energy and services segment performance
> - Key quotes from management on guidance
> - What analysts are saying post-earnings
> - Bull and bear reactions
> 
> Deliver as a concise PDF report with charts."

---

## Tips for Better Financial Analysis

1. **Be specific about metrics**: "Revenue growth" is vague. "YoY revenue growth for the last 8 quarters with segment breakdown" is precise.

2. **Specify time horizons**: "Analyze AAPL" is open-ended. "Analyze AAPL's performance and outlook for the next 12 months" is actionable.

3. **State your purpose**: "For an investment decision", "For a board presentation", "For personal planning" — context shapes the analysis.

4. **Include constraints**: Budget, risk tolerance, time horizon, tax situation — these matter for financial recommendations.

5. **Request scenarios**: "Include bear, base, and bull cases" gives you a range, not just a point estimate.

6. **Ask for the deliverable you need**: "Interactive dashboard", "PDF memo", "Excel model" — specify the format for the best result.
