# Prompt Writing Guide

## Filtrix AI Prompt Library

Browse 100+ curated, production-tested prompts at [filtrix.ai/prompts](https://www.filtrix.ai/prompts).

Each prompt includes the exact text used to generate the example image. Copy directly or use as a starting point.

## Style Categories Available

portrait, lifestyle, fashion-editorial, pop-art, macro-photography, claymation, vintage-cinematic, product-photography, isometric-3d, interior-design, infographic, cyberpunk, craft-art, collectible-toy, sci-fi-landscape, stained-glass, ink-wash, origami, neon-art, vaporwave, and more.

## Prompt Structure Best Practices

A strong prompt follows this pattern:

```
[Subject] + [Action/Pose] + [Style/Medium] + [Lighting] + [Composition] + [Details]
```

### Examples by Category

**Portrait:**
```
A woman with flowing red hair, dramatic side lighting, oil painting style, 
rich warm tones, close-up composition, visible brushstrokes
```

**Product Photography:**
```
A glass perfume bottle on a marble surface, soft studio lighting, 
water droplets on glass, shallow depth of field, luxury brand aesthetic
```

**Sci-Fi/Cyberpunk:**
```
A neon-lit alleyway in a futuristic city, rain-soaked streets reflecting 
holographic advertisements, cinematic wide angle, blade runner atmosphere
```

**Craft Art (trending):**
```
A fox made entirely of intricate paper quilling, white background, 
macro photography, detailed paper strips forming fur texture
```

## Tips from Filtrix's Experience

1. **Be specific about medium/style** — "oil painting" beats "artistic". "Crochet amigurumi" beats "cute craft".
2. **Lighting matters** — "dramatic side lighting", "golden hour", "soft studio lighting" dramatically change results.
3. **Composition keywords** — "close-up", "wide angle", "bird's eye view", "isometric" guide framing.
4. **Trending styles that perform well:**
   - Paper cut art / origami
   - Claymation / stop-motion aesthetic
   - Stained glass art
   - Double exposure
   - Knitted/crochet texture portraits
5. **For edits (image-to-image):** Be explicit about what to change and what to keep. "Transform the background to a sunset beach, keep the subject unchanged."
6. **Negative framing:** Instead of "no blur", say "sharp focus, crisp details". Most models respond better to positive instructions.
