---
name: Files
description: Safely organize, deduplicate, and analyze files with intelligent bulk operations and full undo support.
metadata: {"clawdbot":{"emoji":"📁","os":["linux","darwin","win32"]}}
---

## What This Skill Does (and Doesn't)

**YES:** Organize existing files, find duplicates, analyze disk usage, batch rename/move, clean up clutter
**NO:** Open files, create files/folders, copy files, extract archives, basic file browsing — use standard file operations for those

This is a power tool for reorganization, not a replacement for basic file commands.

## Path Security (Non-Negotiable)

- Canonicalize ALL paths before any operation: resolve `..`, `~`, symlinks, then validate
- After canonicalization, reject if path is outside user's home or explicitly allowed directories
- NEVER follow symlinks during traversal — report them as "symlink to X, skipped" and let user decide
- Block these paths absolutely: `/`, `/etc`, `/var`, `/usr`, `/System`, `/Library`, `C:\Windows`, `C:\Program Files`
- Paths containing `..` after canonicalization = reject with explanation

## Fast Path vs Safe Path

**Fast path (1-9 files):** Execute immediately with brief confirmation: "Move 3 files to Archive? [Y/n]"
**Safe path (10+ files):** Create manifest, show summary, require explicit "yes" or review

This prevents confirmation fatigue for simple operations while protecting bulk actions.

## Trash Handling

- Use the operating system's native trash: `trash` CLI on macOS/Linux, Recycle Bin API on Windows
- If OS trash unavailable, move to `~/.local/share/file-organizer-trash/` with metadata sidecar
- Metadata sidecar (JSON): original path, deletion timestamp, operation ID — NOT path-in-filename
- Never permanently delete without explicit "permanently delete" or "empty trash" command

## Undo System

- Every operation creates an undo record in `~/.local/share/file-organizer/undo/TIMESTAMP.json`
- Record contains: operation type, source paths, destination paths, checksums of moved files
- "Undo last" reverses the most recent operation using the record
- Undo records expire after 30 days — warn user before expiry
- NO shell scripts for undo — JSON metadata only, executed by the agent

## Symlink Policy

- During directory traversal: skip symlinks, report them separately
- "This folder contains 12 symlinks pointing outside — review before proceeding?"
- Never follow symlinks automatically — they're a classic attack vector
- User can explicitly request "follow symlinks" but must confirm each external target

## Duplicate Detection (Scalable)

- Phase 1: Group by exact size (instant, no I/O)
- Phase 2: Hash first 4KB of same-size files (fast filter)
- Phase 3: Full hash only for files matching phase 2
- For >10,000 files, require confirmation: "This will take ~15 minutes. Proceed?"
- Cache hashes in `~/.local/share/file-organizer/hash-cache.db` (SQLite) with mtime invalidation

## Bulk Operations

- **Batch rename:** Preview ALL transformations if <50 files, first/last 10 if more, always show total count
- **Batch move:** Verify destination has space before starting, atomic per-file with rollback on error
- **Progress:** Update every 5% or 30 seconds, whichever is less frequent — not per-file spam
- **Error handling:** On ANY error, stop, report what succeeded/failed, offer "continue skipping errors" or "rollback completed"

## Organization Proposals

- Analyze directory contents FIRST, then propose: "80% images, 15% videos, 5% docs — organize by date or type?"
- Always show concrete examples: "vacation-photo.jpg → 2024/06-June/vacation-photo.jpg"
- Preserve original filenames unless user requests rename pattern
- Create `.file-organizer-manifest.json` in destination documenting the reorganization for future reference

## Size Analysis

- Top consumers by directory, not individual files — users think in folders
- Flag known safe-to-delete: node_modules, __pycache__, .gradle, build/, target/, Pods/
- Calculate actual vs apparent size (sparse files, hardlinks)
- For cleanup suggestions, always state recoverability: "Deleting node_modules: fully recoverable with npm install"

## Platform Specifics

- macOS: Respect .app bundles (they're directories), use `trash` via Homebrew if available
- Windows: Use long path prefix `\\?\` for paths >260 chars, use shell API for Recycle Bin
- Linux: XDG trash spec (`~/.local/share/Trash/`), handle different filesystem capabilities

## Limits and Failures

- Refuse operations on >100,000 files without explicit override: "This affects 250K files. Type 'I understand' to proceed"
- If manifest would exceed 10MB, paginate: "Showing batch 1 of 15 (page through with 'next')"
- Network drives: detect by response time, warn about reliability, suggest local copy first
- Disk full: check before starting, reserve 1% headroom, fail gracefully with partial completion report
