---
name: file-organizer-skill
description: Organize files in directories by grouping them into folders based on their extensions or date. Includes Dry-Run, Recursive, and Undo capabilities.
---

# File Organizer (Gold Standard)

## Features
- **Smart Sorting**: Group by Extension (Default) or Date (Year/Month).
- **Safety**: Conflict resolution (auto-rename), Dry Run mode, and Undo capability.
- **Deep Clean**: Recursive scanning option.
- **Audit**: Generates `organize_history.json` for tracking.

## Usage

### Basic Sort (by Extension)
```bash
python3 scripts/organize.py /path/to/folder
```

### Date Sort (Year/Month)
Great for photos or archives.
```bash
python3 scripts/organize.py /path/to/folder --date
```

### Dry Run (Simulate)
See what *would* happen without moving anything.
```bash
python3 scripts/organize.py /path/to/folder --dry-run
```

### Undo
Revert changes using the history file.
```bash
python3 scripts/organize.py --undo /path/to/folder/organize_history.json
```

## Config
Modify `scripts/organize.py` `get_default_mapping()` to add custom extensions.
