# Academic Figure Legend Style Guide

## General Principles

1. **Self-contained**: Legends should be understandable without reading the main text
2. **Precise**: Use specific measurements, sample sizes, and statistical tests
3. **Concise**: Avoid redundancy with the main text
4. **Standardized**: Follow journal-specific formatting requirements

## Structure

### Required Elements
1. **Brief Title** - One line describing the main finding
2. **Sample Description** - What was measured and in what
3. **Sample Size** - n values for all experiments
4. **Statistics** - Tests used and significance thresholds
5. **Definitions** - Abbreviations and symbols explained

### Optional Elements
- Scale bars (microscopy)
- Color keys (heatmaps)
- Gating strategies (flow cytometry)
- Molecular weight markers (Western blots)

## Statistical Notation

| Symbol | Meaning |
|--------|---------|
| * | p < 0.05 |
| ** | p < 0.01 |
| *** | p < 0.001 |
| ns | not significant (p ≥ 0.05) |
| § | p < 0.05 vs control |

## Common Abbreviations

| Abbreviation | Full Term |
|--------------|-----------|
| SEM | Standard Error of the Mean |
| SD | Standard Deviation |
| IQR | Interquartile Range |
| CI | Confidence Interval |
| ns | not significant |
| WT | Wild Type |
| KO | Knockout |
| OE | Overexpression |

## Journal-Specific Requirements

### Nature Series
- Maximum 350 words per legend
- No methods in legends (use methods section)
- Define all abbreviations at first use

### Cell Press
- Bold figure numbers
- Statistical significance defined in legend
- Sample sizes always required

### Science
- Concise descriptions preferred
- Supplementary methods referenced when appropriate
- Scale bars required for all images

## Language Guidelines

### Active vs Passive Voice
- Use active voice when emphasizing the action
- Use passive voice when the actor is unknown or unimportant

### Examples
- **Good**: "Treatment with X reduced cell proliferation by 50%."
- **Avoid**: "Cell proliferation was reduced by treatment with X."

### Tense Usage
- Use past tense for describing experiments performed
- Use present tense for stating general truths and findings

### Examples
- **Past**: "Cells were treated with..."
- **Present**: "Data represent mean ± SEM..."
