# 费曼学习法教练 - 使用示例

## 示例 1：基础使用流程

### 场景
你昨天学习了决策树算法，今天想要巩固理解。

### 交互流程

```
用户：用费曼技巧帮我回顾一下[[决策树算法]]

AI（费曼教练）：
好的！我是你的费曼学习教练。现在我将扮演一个对机器学习完全不懂的初学者，请你用简单的语言向我解释"决策树算法"。

让我们开始吧！

---

**🎓 学生提问 1/7**

"你好！我听说你在学习决策树，能告诉我什么是决策树吗？它和我们平时看到的树有什么关系？"

---

请用简单的语言向我解释（就像教一个完全不懂的人）：

用户：
决策树就像是你做决策时画的一张流程图。比如说你要决定周末要不要去郊游，你可能会先看"天气好不好"，如果不好就待在家，如果好再看"有没有朋友一起去"...这样一层层问下去，最后就得到决定。计算机用这种方法来做分类预测。

AI（费曼教练）：
哇，这个例子很生动！用"周末郊游"来解释真的很形象。让我继续提问...

**🎓 学生提问 2/7**

"那计算机怎么知道要先问'天气'，而不是先问'有没有朋友'呢？这个顺序是怎么定的？"

[继续交互...]

---

**📊 费曼学习诊断报告**

## 理解度评估

**总体评分：82/100** ⭐⭐⭐⭐

### ✅ 理解良好的部分
- 能用生活化的例子解释核心概念
- 清楚说明决策树的决策流程
- 理解分类预测的应用场景

### ⚠️ 需要加强的部分
- **信息增益的计算原理**
  - 建议：了解熵的概念和计算公式
  - 资源：[[信息论基础]]

- **剪枝策略**
  - 建议：理解为什么要剪枝，以及预剪枝和后剪枝的区别

### ❌ 理解有误的部分
- 暂无

### 🎯 个性化学习建议

1. **立即行动**
   - 阅读 [[信息论基础]] 第3章
   - 尝试手动计算一个简单的信息增益例子

2. **本周目标**
   - 理解决策树与其他分类器（如SVM）的区别
   - 学习随机森林的基本概念

### 📝 针对性练习题

**练习 1**：给定以下数据集，计算"年龄"属性的信息增益...

**练习 2**：在以下场景中，你会选择预剪枝还是后剪枝？为什么？...

---

💡 **下次回顾建议**：3天后，重点练习信息增益计算
```

## 示例 2：每日自动回顾

### 配置

在项目根目录创建 `.opencode/config.toml`：

```toml
[feynman-coach]
enabled = true
review_time = "09:00"
days_between_reviews = 1
review_scope = "recent_notes"
max_daily_concepts = 3
output_format = "obsidian"
```

### 定时任务设置（Windows）

```powershell
# 创建每日9点的定时任务
$action = New-ScheduledTaskAction -Execute "python" -Argument "$PWD\skills\feynman-coach\scripts\daily_review.py"
$trigger = New-ScheduledTaskTrigger -Daily -At 9am
Register-ScheduledTask -Action $action -Trigger $trigger -TaskName "FeynmanDailyReview" -Description "每日费曼学习回顾"
```

### 生成的每日回顾任务示例

文件位置：`Z_Utils/feynman-coach/daily-reviews/review-2025-02-13.md`

```markdown
---
theme: 费曼学习回顾 - 2025-02-13
date: 2025-02-13
time: 09:00
tags:
  - Record/费曼回顾
---

# 🧠 费曼学习每日回顾 - 2025-02-13

> 💡 **费曼学习法**：如果你不能用简单的语言解释某件事，那你并没有真正理解它。

## 📋 今日回顾清单

### 1. [[决策树算法]]

**文件路径**：`1_我的创作/A-决策树算法学习笔记.md`

**费曼挑战问题**：
   1. 请用一句话解释 决策树算法 的核心概念
   2. 这个概念与什么生活例子最相似？请用类比说明
   3. 如果向一个完全不懂的人解释，你会怎么说？
   4. 这个概念的关键组成部分有哪些？
   5. 在实际应用中，这个概念如何发挥作用？
   6. 这个概念容易与什么混淆？它们的区别是什么？
   7. 你能举一个具体的例子来说明吗？

**我的解释**：
（在这里写下你的解释...）

**理解自评**：
- [ ] 完全理解，可以清晰解释
- [ ] 基本理解，但有些地方模糊
- [ ] 不太理解，需要重新学习

**薄弱环节记录**：
（AI 诊断后会在这里记录...）

---

### 2. [[神经网络基础]]

[类似结构...]

---

### 3. [[正则化方法]]

[类似结构...]

---

## 📊 今日学习统计

- **回顾概念数**：3
- **预计用时**：45 分钟
- **完成状态**：
  - [ ] 完成所有回顾
  - [ ] 记录了薄弱环节
  - [ ] 生成了复习卡片

## 🎯 明日建议

根据今日回顾情况，建议明天重点复习：
- 信息增益的数学原理
- L1 和 L2 正则化的区别

---

**触发时间**：2025-02-13 09:00  
**配置模式**：recent_notes
```

## 示例 3：薄弱点专项训练

### 场景
之前的回顾中，你发现对"信息增益"理解不够深入。

### 交互流程

```
用户：针对信息增益这个薄弱点进行专项训练

AI（费曼教练）：
好的！我注意到你之前在学习决策树时，对"信息增益"这个概念的掌握度是 60%。让我们进行专项强化训练！

---

**🎯 专项训练：信息增益**

**前置知识检查**：

在讲信息增益之前，我想确认一下：
1. 你知道什么是"熵"吗？能解释一下吗？
2. 为什么我们要用熵来衡量数据的不确定性？

请用自己的话解释这两个概念。

---

用户：
熵就是描述数据混乱程度的一个指标。如果数据很纯，比如全是正例，那熵就低；如果数据很混乱，正负例各占一半，那熵就高。

AI（费曼教练）：
很好！理解得很到位。那现在我们来深入信息增益...

**核心概念讲解**：

信息增益 = 分裂前的熵 - 分裂后的加权平均熵

让我用一个具体的例子来说明：

假设我们有以下数据集：
[表格展示]

现在我们要计算"天气"这个属性的信息增益...

[详细讲解和计算过程]

---

**📝 专项练习**

**练习 1**：计算题
给定数据集...
请计算属性 A 的信息增益。

**练习 2**：应用题
在以下场景中，你会选择哪个属性作为第一个分裂节点？为什么？

**练习 3**：对比分析
信息增益和信息增益率有什么区别？什么时候应该用后者？

---

**✅ 训练完成！**

本次专项训练完成。建议：
1. 完成上述3道练习题
2. 3天后再次回顾信息增益概念
3. 阅读 [[C4.5算法]] 了解信息增益率
```

## 示例 4：知识体系梳理

### 场景
你想要梳理深度学习的知识体系，找出知识盲区。

### 交互流程

```
用户：帮我梳理一下深度学习的知识体系

AI（费曼教练）：
好的！我将帮你梳理深度学习的知识体系。让我先搜索你的笔记库...

---

**📚 发现的相关笔记**：

1. [[神经网络基础]] - 修改于 2天前
2. [[反向传播算法]] - 修改于 3天前
3. [[卷积神经网络]] - 修改于 5天前
4. [[优化算法]] - 修改于 1周前
5. [[正则化方法]] - 修改于 2天前
6. [[循环神经网络]] - 修改于 2周前

---

**🗺️ 知识体系图谱**

```
深度学习
├── 基础组件
│   ├── 神经元与激活函数 ✓
│   ├── 前向传播 ✓
│   └── 反向传播 ✓
├── 网络架构
│   ├── CNN (卷积神经网络) ✓
│   ├── RNN (循环神经网络) ⚠️ (2周未复习)
│   └── Transformer ? (未找到相关笔记)
├── 训练技巧
│   ├── 优化算法 (SGD, Adam) ✓
│   ├── 正则化 (L1, L2, Dropout) ✓
│   └── 批归一化 ? (未找到相关笔记)
└── 应用实践
    ├── 图像分类 ✓
    ├── 目标检测 ? (未找到相关笔记)
    └── 自然语言处理 ? (未找到相关笔记)
```

**图例**：
- ✓ 已学习且近期复习
- ⚠️ 已学习但需复习
- ? 知识空白

---

**🔍 知识盲区识别**

基于你的笔记分析，发现以下知识空白：

1. **Transformer 架构**
   - 重要性：⭐⭐⭐⭐⭐
   - 建议：这是当前最重要的架构，建议优先学习
   - 资源：[[Attention Is All You Need]]

2. **批归一化 (Batch Normalization)**
   - 重要性：⭐⭐⭐⭐
   - 建议：训练深度网络的关键技术
   - 资源：[[批归一化原理解析]]

3. **目标检测**
   - 重要性：⭐⭐⭐
   - 建议：如果做计算机视觉，这是必学内容
   - 资源：[[YOLO算法]], [[R-CNN系列]]

---

**📈 个性化学习路径**

根据你的知识现状，建议按以下顺序学习：

**第1周**：Transformer 基础
- 学习 Self-Attention 机制
- 理解 Multi-Head Attention
- 实现一个简单的 Transformer

**第2周**：批归一化与高级训练技巧
- 理解 BN 的原理
- 学习 Layer Norm、Group Norm
- 对比各种归一化方法

**第3周**：复习与整合
- 回顾所有基础概念
- 建立完整的知识图谱
- 完成综合练习

---

💡 **提示**：我已经将这些建议保存到你的笔记中，并设置了复习提醒。
```

## 示例 5：与 Obsidian 集成

### 在 Obsidian 日记中使用

1. **运行每日回顾脚本**
   ```bash
   python skills/feynman-coach/scripts/daily_review.py
   ```

2. **在 Obsidian 中打开生成的文件**
   - 文件位置：`Z_Utils/feynman-coach/daily-reviews/review-2025-02-13.md`

3. **完成回顾任务**
   - 阅读问题
   - 在"我的解释"部分写下答案
   - 勾选"理解自评"
   - 记录薄弱环节

4. **使用 Dataview 查看统计**

   创建一个查询页面：
   ```markdown
   # 费曼学习统计
   
   ## 本月回顾记录
   
   ```dataview
   TABLE date, tags
   FROM "Z_Utils/feynman-coach/daily-reviews"
   WHERE date > date(today) - dur(30 days)
   SORT date DESC
   ```
   
   ## 薄弱环节统计
   
   ```dataview
   TABLE concept, weakness_type, severity
   FROM "Z_Utils/feynman-coach/history"
   WHERE severity = "high"
   SORT date DESC
   ```
   ```

## 示例 6：命令行使用

### 列出可回顾的笔记

```bash
$ python skills/feynman-coach/scripts/daily_review.py --list

📚 最近可回顾的笔记：
1. 决策树算法 (1_我的创作/A-决策树算法学习笔记.md)
2. 神经网络基础 (1_我的创作/A-神经网络基础.md)
3. 正则化方法 (1_我的创作/A-正则化方法.md)
```

### 试运行（不保存文件）

```bash
$ python skills/feynman-coach/scripts/daily_review.py --dry-run

🔍 试运行模式（不会保存文件）

将会选择以下 3 个笔记：
  - 决策树算法
  - 神经网络基础
  - 正则化方法
```

### 使用自定义配置

```bash
$ python skills/feynman-coach/scripts/daily_review.py --config my-config.json

🧠 费曼学习教练 - 每日回顾
==================================================

📚 正在选择今日回顾内容...
✅ 已选择 3 个概念：
   - 决策树算法
   - 神经网络基础
   - 正则化方法

📝 正在生成回顾任务...
✅ 回顾任务已保存到：Z_Utils\feynman-coach\daily-reviews\review-2025-02-13.md

✨ 每日回顾任务已生成！
📄 文件位置：Z_Utils\feynman-coach\daily-reviews\review-2025-02-13.md

💡 提示：使用 Obsidian 打开查看完整任务，或运行 'opencode' 开始交互式回顾。
```

## 更多使用场景

### 考试前复习
```
用户：我下周有机器学习考试，帮我制定复习计划

AI：基于你的笔记，我建议...
```

### 演讲前准备
```
用户：我要给同事讲解 Docker，帮我准备一下

AI：好的！让我用费曼技巧帮你准备...
```

### 学习新领域
```
用户：我想学习强化学习，从哪里开始？

AI：让我先了解你现有的知识基础...
```

---

**提示**：更多示例和用法请参考 `SKILL.md` 文档。
