---
name: feynman-coach
description: |
  基于费曼学习法的个人知识教练，通过"以教代学"的方式帮助用户深度理解和巩固知识。
  支持主动知识回顾、薄弱点诊断、个性化学习建议，并可通过配置实现每日自动触发知识回顾。
  触发命令：/feynman（直接调用费曼学习功能）
---

# 费曼学习法知识教练 (Feynman Coach)

## 核心理念

费曼学习法由诺贝尔物理学奖得主理查德·费曼提出，核心原则是：**如果你不能用简单的语言解释某件事，那你并没有真正理解它**。

本 Skill 将 AI 作为你的"虚拟学生"和"个人教练"，通过四个步骤帮助你实现深度学习和长期记忆：

1. **选择概念** - 从笔记中选择要回顾的知识点
2. **讲解教学** - 向 AI 学生解释这个概念
3. **识别差距** - AI 指出理解盲点和薄弱环节
4. **复习巩固** - 针对性强化，生成复习材料

## 何时使用此 Skill

**触发场景**：
- 学习新知识后需要巩固理解
- 准备考试或演讲前复习
- 发现学过的知识容易遗忘
- 想要检验自己对某个概念的真正理解程度
- 需要整理知识体系，发现知识盲点
- **每日自动回顾**（需配置定时任务）

**关键词触发**：
- "帮我回顾一下..."
- "用费曼技巧学习..."
- "测试一下我对...的理解"
- "每天提醒我复习..."
- "知识教练"
- "费曼学习"

## 工作流程

### 模式 1：主动知识回顾（默认）

当你想要回顾某个知识点时使用：

```
用户：用费曼技巧帮我回顾一下[[机器学习中的过拟合]]
```

**执行流程**：
1. **读取知识源** - 从你的笔记中读取相关内容
2. **模拟教学** - 你向 AI 学生解释概念
3. **提问挑战** - AI 提出基础到深入的问题
4. **诊断分析** - AI 分析你的理解盲点
5. **生成建议** - 提供个性化学习建议和复习材料

### 模式 2：薄弱点专项训练

针对已识别的薄弱环节进行强化：

```
用户：针对昨天的薄弱点进行专项训练
```

**执行流程**：
1. **读取历史记录** - 查看之前的诊断结果
2. **针对性提问** - 重点针对薄弱环节提问
3. **深度解析** - 提供详细的解释和示例
4. **生成练习** - 创建针对性练习题

### 模式 3：知识体系梳理

帮助你建立知识间的联系：

```
用户：帮我梳理一下深度学习的知识体系
```

**执行流程**：
1. **搜索相关笔记** - 找到所有相关知识点
2. **构建知识图谱** - 分析概念间的关系
3. **识别缺失环节** - 发现知识体系中的空白
4. **生成学习路径** - 提供系统化的学习建议

## 使用方法

### 基本用法

**步骤 1：选择要回顾的知识**

```
用户：费曼教练，帮我回顾[[决策树算法]]
```

**步骤 2：开始讲解**

AI 会扮演一个好奇但完全不懂的学生，你需要用简单的语言向它解释。

**步骤 3：回答问题**

AI 会提出各种问题，从基础到深入：
- "什么是决策树？"
- "信息增益是什么意思？"
- "决策树和随机森林有什么区别？"
- "过拟合怎么解决？"

**步骤 4：查看诊断报告**

讲解结束后，AI 会生成诊断报告：
- ✅ 理解良好的部分
- ⚠️ 需要加强的部分
- ❌ 理解有误的部分
- 📚 推荐的学习资源

### 高级用法

**配置每日自动回顾**

在 `.opencode/config.toml` 中添加：

```toml
[feynman-coach]
enabled = true
review_time = "09:00"  # 每天上午9点触发
days_between_reviews = 1  # 每隔1天回顾一次
review_scope = "recent_notes"  # 可选：recent_notes, random, tagged
review_tags = ["#学习", "#重要"]  # 如果 review_scope = "tagged"
max_daily_concepts = 3  # 每天最多回顾3个概念
```

**手动触发每日回顾**

```
用户：/feynman daily-review
```

**查看学习统计**

```
用户：/feynman stats
```

**导出复习卡片**

```
用户：/feynman export-cards [[决策树算法]]
```

## 输出格式

### 诊断报告示例

```markdown
# 费曼学习诊断报告

## 回顾主题：决策树算法

### 📊 理解度评估

**总体评分：75/100**

#### ✅ 理解良好的部分 (40%)
- 决策树的基本概念和结构
- 分类和回归的区别
- 树的构建过程

#### ⚠️ 需要加强的部分 (45%)
- **信息增益的计算原理**
  - 建议：复习熵和信息增益的数学公式
  - 资源：[[信息论基础]]
  
- **剪枝策略的选择**
  - 建议：理解预剪枝和后剪枝的适用场景
  - 资源：[[模型正则化方法]]

#### ❌ 理解有误的部分 (15%)
- **基尼指数 vs 信息增益**
  - 误区：认为两者计算结果相同
  - 纠正：基尼指数偏向多分类，信息增益更通用
  - 建议：对比两者的数学定义和适用场景

### 🎯 个性化学习建议

1. **立即行动**
   - 阅读 [[信息论基础]] 第3章
   - 完成下方的针对性练习

2. **本周目标**
   - 理解信息增益的数学推导
   - 能够手动计算简单数据集的信息增益

3. **长期规划**
   - 将决策树与其他模型对比（SVM、神经网络）
   - 学习集成方法（随机森林、XGBoost）

### 📝 针对性练习题

**练习 1：计算题**
给定数据集...
请计算属性 A 的信息增益。

**练习 2：应用题**
在以下场景中，你会选择哪种剪枝策略？为什么？
...

**练习 3：对比分析**
比较决策树和逻辑回归在以下方面的异同：...

### 🔗 相关知识链接

- [[信息论基础]]
- [[模型评估指标]]
- [[集成学习方法]]
- [[特征工程技巧]]

### 📅 下次回顾建议

**建议时间**：3天后
**重点内容**：信息增益计算、剪枝策略
**预计时长**：20分钟
```

### 复习卡片格式

```markdown
# 决策树算法 - 复习卡片

## 卡片 1：基础概念
**正面**：什么是决策树？
**背面**：决策树是一种...

## 卡片 2：核心算法
**正面**：ID3、C4.5、CART 的区别？
**背面**：...

## 卡片 3：常见问题
**正面**：决策树容易过拟合，如何解决？
**背面**：...
```

## 自动触发机制

### 配置说明

本 Skill 支持通过以下方式实现每日自动触发：

#### 方式 1：使用系统定时任务（推荐）

**Windows (PowerShell)**：
```powershell
# 创建每日任务
$action = New-ScheduledTaskAction -Execute "opencode" -Argument "run /feynman daily-review"
$trigger = New-ScheduledTaskTrigger -Daily -At 9am
Register-ScheduledTask -Action $action -Trigger $trigger -TaskName "FeynmanDailyReview" -Description "每日费曼学习回顾"
```

**macOS/Linux (cron)**：
```bash
# 编辑 crontab
crontab -e

# 添加每日9点执行
0 9 * * * cd /path/to/your/project && opencode run /feynman daily-review
```

#### 方式 2：使用 Obsidian 插件

如果你使用 Obsidian，可以安装 **Templater** 或 **Dataview** 插件，结合本 Skill 实现：

1. 创建每日笔记模板
2. 在模板中添加费曼回顾按钮
3. 点击按钮触发 Skill

#### 方式 3：使用 GitHub Actions

如果你将笔记放在 GitHub 上，可以配置 GitHub Actions：

```yaml
# .github/workflows/feynman-review.yml
name: Daily Feynman Review
on:
  schedule:
    - cron: '0 9 * * *'  # 每天 UTC 9点

jobs:
  review:
    runs-on: ubuntu-latest
    steps:
      - uses: actions/checkout@v2
      - name: Run Feynman Coach
        run: |
          opencode run /feynman daily-review
```

### 触发时行为

当自动触发时，费曼教练会：

1. **选择回顾内容**
   - 根据配置选择最近学习的笔记
   - 或随机选择标记为 #复习 的笔记
   - 或选择之前诊断出有薄弱点的笔记

2. **生成回顾任务**
   - 创建 Todo 列表
   - 发送到 Obsidian 每日笔记
   - 或显示通知提醒

3. **执行回顾流程**
   - 读取笔记内容
   - 生成针对性问题
   - 等待用户回答（交互式）
   - 或生成自测卡片（非交互式）

## 最佳实践

### 学习节奏建议

- **新学知识**：学习当天进行第一次费曼回顾
- **短期巩固**：3天后进行第二次回顾
- **长期记忆**：1周后、1个月后分别回顾
- **定期梳理**：每月进行一次知识体系梳理

### 提问技巧

**好的解释应该**：
- 使用类比和生活化例子
- 避免专业术语，或解释术语
- 从简单到复杂，循序渐进
- 包含具体的例子和应用场景

**如果卡住了**：
- 承认自己不懂的地方
- 回到原始材料重新学习
- 用更简单的方式重新解释
- 请求 AI 提供提示和引导

### 知识管理建议

1. **标记重要概念**
   - 使用 `#费曼回顾` 标签
   - 添加 `NextReview: 2025-02-20` 元数据

2. **建立知识链接**
   - 在笔记中添加 `RelatedNotes:`
   - 使用 Obsidian 的图谱视图

3. **记录学习历程**
   - 保存每次诊断报告
   - 追踪理解度变化
   - 记录常见误区

## 故障排除

### 常见问题

**Q: 自动触发没有工作？**
A: 检查以下几点：
- 定时任务是否正确配置
- opencode 是否在系统 PATH 中
- 项目路径是否正确

**Q: AI 提出的问题太简单/太难？**
A: 可以在提问时说明你的水平：
```
我是初学者，请从基础开始提问
```
或
```
我已经掌握基础，请深入提问
```

**Q: 如何跳过某个知识点？**
A: 在诊断报告中会提供跳过选项，或手动编辑笔记添加 `#跳过回顾` 标签。

**Q: 回顾历史记录保存在哪里？**
A: 默认保存在 `Z_Utils/feynman-coach/history/` 目录下，按日期组织。

## 进阶配置

### 自定义评分标准

在 `SKILL.md` 同级目录创建 `config.json`：

```json
{
  "scoring": {
    "clarity_weight": 0.3,
    "accuracy_weight": 0.4,
    "depth_weight": 0.2,
    "examples_weight": 0.1
  },
  "difficulty_levels": {
    "beginner": {"depth": "basic", "questions": 3},
    "intermediate": {"depth": "medium", "questions": 5},
    "advanced": {"depth": "deep", "questions": 7}
  }
}
```

### 集成其他工具

**与 Anki 集成**：
```bash
# 导出复习卡片到 Anki
opencode run /feynman export-anki [[决策树算法]]
```

**与 Notion 集成**：
```bash
# 同步学习记录到 Notion
opencode run /feynman sync-notion
```

## 参考资源

- [费曼学习法原文](https://fs.blog/feyman-technique/)
- [Obsidian 间隔重复插件](https://github.com/st3v3nmw/obsidian-spaced-repetition)
- [Anki 记忆卡片软件](https://apps.ankiweb.net/)

## 版本历史

- v1.0 (2025-02-13) - 初始版本，支持基础费曼学习流程
- v1.1 (计划中) - 添加自动触发机制
- v1.2 (计划中) - 添加学习统计和可视化
- v1.3 (计划中) - 添加 Anki/Notion 集成

---

**提示**：本 Skill 需要配合 Obsidian 或其他笔记软件使用，确保你的知识库有良好的结构和链接关系，这样费曼教练才能发挥最大效果。
