---
name: feishu-wiki
description: 飞书知识库 Skill。创建知识空间、创建 Wiki 页面节点。当需要在飞书知识库中组织和沉淀文档时使用此 Skill。
required_permissions:
  - wiki:wiki
  - wiki:node:create
---

# 飞书知识库

你是飞书知识库管理专家，负责通过 Wiki v2 API 实现知识空间和页面节点的创建与管理。

---

## 一、API 基础信息

| 项目 | 值 |
|------|---|
| Base URL | `https://open.feishu.cn/open-apis/wiki/v2` |
| 认证方式 | `Authorization: Bearer {tenant_access_token}` |
| Content-Type | `application/json` |

---

## 二、知识空间

### 1. 创建知识空间

```
POST /open-apis/wiki/v2/spaces
```

```json
{ "name": "知识库名称" }
```

**实测心法 (重要)**：
1. **权限穿透**：空间创建后机器人默认无权维护。**强烈建议使用“群组授权法”**：
   - 创建一个包含机器人的群组。
   - 在知识库【设置】-【成员设置】中，添加该群组为“管理员”。
   - 这样机器人即可通过群组身份获得该空间内所有页面的操作权。
2. **场景建议**：适合为新业务线建立知识中台。

### 2. 获取知识空间列表

```
GET /open-apis/wiki/v2/spaces
```

---

## 三、页面节点

### 3. 创建 Wiki 页面节点

```
POST /open-apis/wiki/v2/spaces/{space_id}/nodes
```

```json
{
  "obj_type": "docx",
  "title": "页面标题",
  "parent_node_token": "wikcnXXX"
}
```

**实测心法**：
- Wiki 节点实质上是 Docx 文件的挂载
- `obj_type` 可选 `docx`（文档）、`sheet`（表格）、`bitable`（多维表格）等
- 创建后可通过 `feishu-doc-writer` Skill 向文档写入内容
- `parent_node_token` 为空则创建在根目录

### 4. 获取节点信息

```
GET /open-apis/wiki/v2/spaces/{space_id}/nodes/{node_token}
```

### 5. 移动节点

```
POST /open-apis/wiki/v2/spaces/{space_id}/nodes/{node_token}/move
```

---

## 四、最佳实践

1. **结构先行**：先规划知识库的目录结构，再批量创建节点
2. **文档挂载**：Wiki 节点本质是文档的挂载点，内容写入用 `feishu-doc-writer`
3. **权限管理**：空间创建后及时配置访问权限
4. **SOP 沉淀**：将稳定的操作流程沉淀为 Wiki 页面，形成团队知识资产


---


# feishu-wiki 技能总结 (教程脱敏版)

### 一、 核心功能清单

| 功能维度 | 具体能力 | 说明 |
| :--- | :--- | :--- |
| **空间管理** | 空间感知与列表 | 支持一键检索当前应用可见的所有知识空间，实现跨部门的资产发现。 |
| **结构化建档** | 目录树自动化 | 支持通过 API 在指定空间内构建多级父子目录结构，实现知识资产的有序组织。 |
| **资产归档** | 外部文档挂载 | 支持将已存在的云文档 (Docx)、表格 (Sheet) 等外部资产一键“入库”挂载到 Wiki 节点。 |
| **动态治理** | 节点迁移与重命名 | 支持对已有的 Wiki 页面进行目录迁移、重命名及删除操作，确保持久化的知识治理能力。 |

---

### 二、 典型业务场景

**企业级 SOP 自动化沉淀中心：**
*   **场景**：当项目组完成一项复杂任务的复盘讨论后，AI 自动提炼核心步骤，将其转化为标准的 SOP 文档，并精准挂载到公司 Wiki 的「标准化流程」分类下。
*   **价值**：将碎片化经验瞬间固化为组织资产，解决“人走政息、经验流失”的难题。

**项目全生命周期建档：**
*   **场景**：新项目立项时，AI 自动在团队 Wiki 中创建以项目命名的父节点，并预设「PRD」、「需求池」、「会议纪要」等标准化二级子节点。
*   **价值**：实现项目文档的“入场即标准化”，确保团队成员在项目第一天就能在预设框架内协作。

**智能资产整理与迁移：**
*   **场景**：公司进行知识库重构时，AI 自动扫描存量的孤立文档，识别其业务标签，并根据分类逻辑将其自动移动/挂载到对应的 Wiki 目录树中。
*   **价值**：极大地降低了人工维护巨量知识库的行政成本，实现知识体系的动态演进。

---

### 三、 实测注意事项（教程必写 · 尽量详细）

**空间授权的“群组法”穿透 (Critical)：**
*   **风险**：由于飞书租户安全策略，机器人通过 API 直接创建“顶级知识空间”往往会报权限错误 (403)。此外，即便有了空间，机器人默认对空间内的节点也可能无操作权。
*   **对策**：教程必须强调 **“群组授权最佳实践”**：
    1.  手动创建一个包含机器人的【群组】。
    2.  在 Wiki 空间设置中，将该群组添加为【管理员】。
    3.  这样机器人即可通过群组身份获得空间内所有页面的创建、移动和编辑权限。

**Node Token 与 Obj Token 的本质区别：**
*   **坑点**：这是最容易混淆的技术点。`node_token` 代表 Wiki 目录上的一个“位置节点”；而 `obj_token` 才是背后真实的文档文件。
*   **建议**：在执行“内容写入”操作前，务必通过 `get_node` 接口获取 `obj_token`，否则无法调用文档写入接口。

**节点创建的“node_type”强制性：**
*   **注意**：在调用 Wiki 创建节点接口时，`node_type` 字段通常是必传项。在自动化挂载场景下，一般固定设置为 `origin` 即可。

**跨空间移动的参数补全：**
*   **技巧**：在执行 `move_node`（移动节点）时，飞书 API 要求同时提供 `target_parent_token`（目标目录）和 `target_space_id`（目标空间），即便是在同一个空间内移动，这两个参数也建议显式补全，否则极易触发 400 校验错误。

---
*注：以上内容已进行脱敏处理，所有私有项目信息已替换为通用互联网公司业务描述。已保存至：`opensource/feishu-skills/feishu-wiki/SUMMARY.md`*
