# 飞书文档权限配置完整指南

本指南详细说明如何为飞书文档编辑功能配置所需的权限。

---

## 概述

要让应用能够通过 API 编辑飞书文档，需要完成两个层面的权限配置：

1. **应用层权限** - 在飞书开放平台为应用申请 API 权限
2. **文档层权限** - 将应用添加为特定文档的协作者

---

## 第一部分：应用层权限配置

### 步骤 1：创建企业自建应用

1. **登录飞书开放平台**
   - 访问：https://open.feishu.cn
   - 使用企业管理员账号登录

2. **创建应用**
   - 点击"创建企业自建应用"
   - 填写应用信息：
     - 应用名称：例如"文档编辑助手"
     - 应用描述：简要说明应用用途
     - 应用图标：可选

3. **添加能力**
   - 在应用配置页面，找到"能力管理"
   - 添加"机器人"能力
   - 这将赋予应用发送消息和接收通知的能力

---

### 步骤 2：申请 API 权限

在应用的"权限管理"页面，申请以下权限：

#### 文档编辑权限（必需）

| 权限名称 | 权限标识 | 用途 | 必需性 |
|---------|---------|------|--------|
| 查看、评论和导出文档 | `docx:document:readonly` | 读取文档内容 | 必需 |
| 创建文档 | `docx:document:create` | 创建新文档 | 可选 |
| 编辑文档 | `docx:document:write_only` | 修改文档内容 | 必需 |

#### 其他相关权限（可选）

| 权限名称 | 权限标识 | 用途 |
|---------|---------|------|
| 获取与更新云文档信息 | `drive:drive:readonly` | 访问文件元信息 |
| 以应用身份发消息 | `im:message:send_as_bot` | 发送通知 |

---

### 步骤 3：申请权限的详细操作

1. **进入权限管理**
   - 在左侧菜单选择"权限管理"
   - 搜索上述权限名称

2. **申请权限**
   - 找到对应权限后，点击"申请"
   - 填写申请理由：
     - 用途：文档自动化编辑
     - 使用场景：批量处理文档内容
     - 影响范围：特定用户/部门

3. **等待审批**
   - 如果是个人应用，可能自动批准
   - 如果是企业应用，需要管理员审批

---

### 步骤 4：发布应用

权限配置完成后，需要发布应用：

1. **创建版本**
   - 进入"版本管理与发布"
   - 点击"创建新版本"
   - 填写版本号和更新说明

2. **配置可用范围**
   - 选择应用可用范围：
     - 全员可用
     - 部分部门/用户可用
   - 建议先选择"部分用户"进行测试

3. **提交审核**
   - 点击"提交审核"
   - 等待审核通过（通常 1-2 个工作日）

4. **正式发布**
   - 审核通过后，点击"发布"
   - 应用正式上线

---

## 第二部分：文档层权限配置

即使应用有了 API 权限，还需要对每个文档单独授权。

### 方法 1：通过飞书客户端（推荐）

#### 添加应用为文档协作者

1. **打开目标文档**
   - 在飞书客户端或网页版打开文档
   - 确保你有文档的编辑权限

2. **进入协作者管理**
   - 点击右上角的 "..." 按钮
   - 选择"更多"
   - 点击"添加协作者"

3. **添加应用**
   - 在搜索框中输入你的应用名称
   - 选择你的应用（通常显示为机器人图标）
   - 设置权限级别：
     - **可编辑** - 可以修改文档内容
     - **可评论** - 只能添加评论
     - **可查看** - 只能查看
   - 选择"可编辑"

4. **确认添加**
   - 点击"邀请"
   - 应用将出现在协作者列表中

---

### 方法 2：通过 API（高级）

如果需要批量授权多个文档，可以通过 API 实现：

```bash
# 获取应用的 open_id
APP_OPEN_ID="ou_xxxxxxxxx"

# 调用添加协作者 API
curl -X POST "https://open.feishu.cn/open-apis/docx/v1/documents/{document_id}/permissions/permission" \
  -H "Authorization: Bearer {tenant_access_token}" \
  -H "Content-Type: application/json" \
  -d '{
    "permissions": [
      {
        "permission": "docx:document:write",
        "scope_type": "app",
        "scope_id": "'"$APP_OPEN_ID"'"
      }
    ]
  }'
```

---

## 第三部分：验证权限配置

### 验证 1：应用权限检查

1. **检查应用权限状态**
   - 进入飞书开放平台
   - 选择你的应用
   - 查看"权限管理"页面
   - 确认所有必需权限已显示为"已批准"

2. **测试 API 访问**
   ```bash
   # 尝试获取 tenant_access_token
   curl -X POST "https://open.feishu.cn/open-apis/auth/v3/tenant_access_token/internal" \
     -H "Content-Type: application/json" \
     -d '{"app_id": "你的app_id", "app_secret": "你的app_secret"}'
   
   # 如果返回 token，说明应用权限配置正确
   ```

---

### 验证 2：文档权限检查

1. **检查协作者列表**
   - 打开目标文档
   - 点击右上角 "..." → "协作者"
   - 确认你的应用在列表中
   - 确认权限级别为"可编辑"

2. **测试文档访问**
   ```bash
   # 尝试读取文档
   curl -X GET "https://open.feishu.cn/open-apis/docx/v1/documents/{document_id}/plaintext" \
     -H "Authorization: Bearer {tenant_access_token}"
   
   # 如果返回文档内容，说明文档权限配置正确
   ```

---

## 常见问题排查

### 问题 1：403 Forbidden 错误

**症状**：
```json
{
  "code": 403,
  "msg": "permission denied"
}
```

**可能原因**：
1. 应用没有被添加为文档协作者
2. 应用的 API 权限未申请或未批准
3. tenant_access_token 已过期

**解决方案**：
1. 检查文档的协作者列表，确认应用已添加
2. 检查应用权限状态，确认必需权限已批准
3. 重新获取 tenant_access_token

---

### 问题 2：应用未出现在协作者搜索结果中

**可能原因**：
1. 应用未发布
2. 应用可用范围不包含当前用户
3. 应用名称搜索关键词不匹配

**解决方案**：
1. 检查应用是否已发布
2. 在"版本管理与发布"中扩大可用范围
3. 尝试使用完整应用名称搜索

---

### 问题 3：权限申请被拒绝

**可能原因**：
1. 申请理由不充分
2. 企业安全策略限制
3. 缺少必要的合规审批

**解决方案**：
1. 重新提交申请，提供详细的使用场景说明
2. 联系企业管理员说明用途
3. 咨询飞书技术支持

---

## 最佳实践

### 1. 最小权限原则
- 只申请必需的权限
- 定期审查和清理不需要的权限

### 2. 测试环境优先
- 先在测试文档中验证功能
- 确认无问题后再应用到生产环境

### 3. 批量授权策略
- 对于企业内部文档，可以创建专门的文档模板
- 在模板中预先添加应用为协作者
- 新建文档基于模板创建

### 4. 权限监控
- 定期检查应用的文档访问日志
- 监控异常的 API 调用
- 设置告警机制

---

## 权限生命周期管理

### 权限续期
- tenant_access_token 有效期为 2 小时
- 需要定期重新获取
- 建议实现自动续期机制

### 权限撤销
- 如果不再需要访问某个文档，及时撤销应用权限
- 在文档协作者列表中移除应用
- 或通过 API 调用删除权限

### 权限审计
- 定期审查应用拥有的文档权限
- 清理不再需要的文档访问权限
- 记录权限变更历史

---

## 附录：权限配置检查清单

### 应用层配置
- [ ] 创建企业自建应用
- [ ] 添加"机器人"能力
- [ ] 申请 `docx:document:readonly` 权限
- [ ] 申请 `docx:document:write_only` 权限（可选：`docx:document:create`）
- [ ] 提交应用审核
- [ ] 应用发布成功
- [ ] 测试获取 tenant_access_token

### 文档层配置
- [ ] 打开目标文档
- [ ] 进入协作者管理
- [ ] 搜索并添加应用
- [ ] 设置权限级别为"可编辑"
- [ ] 确认添加成功
- [ ] 测试读取文档
- [ ] 测试编辑文档

### 验证测试
- [ ] API 调用返回正确响应
- [ ] 文档内容可以正常读取
- [ ] 文档内容可以正常编辑
- [ ] 错误处理机制正常工作

完成所有检查项后，权限配置就完成了！
