---
name: feishu-sheets
description: |
  Feishu online spreadsheet (Sheets) operations including create, read, write, append data, manage worksheets.
  Use when user mentions Feishu Sheets, online spreadsheet, electronic spreadsheet (not Bitable/multi-dimensional table).
  Supports: create spreadsheet, write/read cell values, append rows, insert/delete rows/columns, manage worksheets.
---

# Feishu Sheets Tool

Single tool `feishu_sheets` with action parameter for all spreadsheet operations.

## Token Extraction

From URL `https://xxx.feishu.cn/sheets/shtABC123` → `spreadsheet_token` = `shtABC123`

## Actions

### Create Spreadsheet

```json
{ "action": "create", "title": "New Spreadsheet" }
```

Optional folder:
```json
{ "action": "create", "title": "New Spreadsheet", "folder_token": "fldcnXXX" }
```

Returns: spreadsheet_token, url, title

### Write Values

```json
{
  "action": "write",
  "spreadsheet_token": "shtABC123",
  "sheet_id": "0bxxxx",
  "range": "A1:C3",
  "values": [["Name", "Age", "City"], ["Alice", 25, "Beijing"], ["Bob", 30, "Shanghai"]]
}
```

### Read Values

```json
{
  "action": "read",
  "spreadsheet_token": "shtABC123",
  "sheet_id": "0bxxxx",
  "range": "A1:C10"
}
```

### Append Values

```json
{
  "action": "append",
  "spreadsheet_token": "shtABC123",
  "sheet_id": "0bxxxx",
  "values": [["Charlie", 28, "Shenzhen"]]
}
```

### Insert Rows/Columns

```json
{
  "action": "insert_dimension",
  "spreadsheet_token": "shtABC123",
  "sheet_id": "0bxxxx",
  "dimension": "ROWS",
  "start_index": 5,
  "end_index": 7
}
```

### Delete Rows/Columns

```json
{
  "action": "delete_dimension",
  "spreadsheet_token": "shtABC123",
  "sheet_id": "0bxxxx",
  "dimension": "ROWS",
  "start_index": 5,
  "end_index": 7
}
```

### Get Spreadsheet Info

```json
{ "action": "get_info", "spreadsheet_token": "shtABC123" }
```

Returns: metadata including all sheet_ids and titles

### Add Worksheet

```json
{
  "action": "add_sheet",
  "spreadsheet_token": "shtABC123",
  "title": "Sheet2"
}
```

### Delete Worksheet

```json
{
  "action": "delete_sheet",
  "spreadsheet_token": "shtABC123",
  "sheet_id": "0bxxxx"
}
```

## Range Format

- Cell: `A1`, `B5`
- Range: `A1:C10`, `B2:D5`
- Entire column: `A:A`, `B:D`
- Entire row: `1:1`, `3:5`
- With sheet_id: `0bxxxx!A1:C10`

## Sheet ID

- From URL: `https://xxx.feishu.cn/sheets/shtABC123?sheet=0bxxxx`
- From get_info action
- Default first sheet often has simple id like `0bxxxx`

## Data Types

Values can be:
- String: `"Hello"`
- Number: `123`, `45.67`
- Formula: `{"type": "formula", "text": "=SUM(A1:A10)"}`
- Link: `{"type": "url", "text": "Click here", "link": "https://..."}`

## Configuration

```yaml
channels:
  feishu:
    tools:
      sheets: true  # default: true
```

## Permissions Required

- `sheets:spreadsheet` - Create and manage spreadsheets
- `sheets:spreadsheet:readonly` - Read spreadsheet data
- `drive:drive` - Access cloud storage

## API Reference

Base URL: `https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/`

See references/api-reference.md for detailed API documentation.
