---
name: feishu-reaction
description: Add or remove emoji reactions on Feishu (Lark) messages. Use when the user asks to react to a message, add an emoji/expression to a message, or when you want to acknowledge a message with a reaction instead of a text reply. Requires Feishu channel configured in OpenClaw with im:message.reactions permission.
---

# Feishu Reaction

Add/remove emoji reactions on Feishu messages via API.

## Usage

```bash
# Add reaction
bash scripts/feishu-reaction.sh <message_id> <emoji_type>

# Remove reaction
bash scripts/feishu-reaction.sh <message_id> <emoji_type> remove
```

Resolve `scripts/feishu-reaction.sh` relative to this skill's directory.

## Getting message_id

The `message_id` comes from inbound message metadata (e.g., `om_x100b554e82c620a4c...`). Use the current message's `message_id` from conversation context.

## Available Emoji Types

Common: `THUMBSUP`, `SMILE`, `OK`, `HEART`, `LOVE`, `THANKS`, `YEAH`, `AWESOME`, `PARTY`, `CLAP`, `APPLAUSE`

Emotions: `CRY`, `ANGRY`, `SHY`, `BLUSH`, `SPEECHLESS`, `TERROR`, `WOW`, `FACEPALM`, `SWEAT`, `PROUD`, `OBSESSED`

Actions: `WAVE`, `HUG`, `KISS`, `WINK`, `TONGUE`, `MUSCLE`, `SALUTE`

Objects: `FIRE`, `BEER`, `CAKE`, `GIFT`, `ROSE`, `FIREWORKS`

Other: `WITTY`, `JIAYI`

## Prerequisites

- Feishu channel configured in OpenClaw (`openclaw.json` has `channels.feishu.appId` and `appSecret`)
- App has `im:message:reaction` permission (飞书开放平台 → 应用权限 → 消息与群组 → 表情回复)

## Examples

React with thumbs up to acknowledge a message:
```bash
bash scripts/feishu-reaction.sh "om_xxx" "THUMBSUP"
```

React with heart to show appreciation:
```bash
bash scripts/feishu-reaction.sh "om_xxx" "HEART"
```

Remove a reaction:
```bash
bash scripts/feishu-reaction.sh "om_xxx" "THUMBSUP" remove
```
