---
name: feishu-messaging
description: |
  飞书消息发送与文档创建工作流。
  触发场景：查找群成员、查找群ID、发送消息失败需要重新尝试。
  适用于：发送飞书消息。
---

# 飞书消息与文档 Skill

## 概述

此 Skill 通过飞书开放平台 API 帮助用户发送消息、创建文档和管理飞书资源。

## 核心能力

| 功能 | 状态 | 所需权限 |
|------|------|---------|
| 发送文本消息 | ✅ 可用 | `im:message:send_as_bot` |
| 获取群聊列表 | ✅ 可用 | `im:chat:readonly` |
| 获取群成员 | ✅ 可用 | `im:chat.members:read` |

## 使用方法

### 发送消息给指定用户

```
给 [姓名] 发一条飞书消息，告诉他 [内容]
```

**前置条件**：需要获取用户的 open_id

### 1. 获取群聊id的方法

```python
import json

import lark_oapi as lark
from lark_oapi.api.im.v1 import *


def main():
    # 创建client
    client = lark.Client.builder() \
        .app_id("YOUR_APP_ID") \
        .app_secret("YOUR_APP_SECRET") \
        .log_level(lark.LogLevel.DEBUG) \
        .build()

    # 构造请求对象
    request: SearchChatRequest = SearchChatRequest.builder() \
        .user_id_type("open_id") \
        .query("小鸭子") \
        .page_size(20) \
        .build()

    # 发起请求
    response: SearchChatResponse = client.im.v1.chat.search(request)

    # 处理失败返回
    if not response.success():
        lark.logger.error(
            f"client.im.v1.chat.search failed, code: {response.code}, msg: {response.msg}, log_id: {response.get_log_id()}, resp:
{json.dumps(json.loads(response.raw.content), indent=4, ensure_ascii=False)}")
        return

    # 处理业务结果
    lark.logger.info(lark.JSON.marshal(response.data, indent=4))


if __name__ == "__main__":
    main()
```

### 2. 发送消息

``` python
import json

import lark_oapi as lark
from lark_oapi.api.im.v1 import *


def main():
    # 创建client
    client = lark.Client.builder() \
        .app_id("YOUR_APP_ID") \
        .app_secret("YOUR_APP_SECRET") \
        .log_level(lark.LogLevel.DEBUG) \
        .build()

    # 构造请求对象
    request: CreateMessageRequest = CreateMessageRequest.builder() \
        .receive_id_type("open_id") \
        .request_body(CreateMessageRequestBody.builder()
            .receive_id("ou_7d8a6e6df7621556ce0d21922b676706ccs")
            .msg_type("text")
            .content("{\"text\":\"test content\"}")
            .uuid("选填，每次调用前请更换，如a0d69e20-1dd1-458b-k525-dfeca4015204")
            .build()) \
        .build()

    # 发起请求
    response: CreateMessageResponse = client.im.v1.message.create(request)

    # 处理失败返回
    if not response.success():
        lark.logger.error(
            f"client.im.v1.message.create failed, code: {response.code}, msg: {response.msg}, log_id: {response.get_log_id()}, resp:
{json.dumps(json.loads(response.raw.content), indent=4, ensure_ascii=False)}")
        return

    # 处理业务结果
    lark.logger.info(lark.JSON.marshal(response.data, indent=4))


if __name__ == "__main__":
    main()

```

### 3. 图片消息

```python
import json

import lark_oapi as lark
from lark_oapi.api.im.v1 import *


def main():
    # 创建client
    client = lark.Client.builder() \
        .app_id("YOUR_APP_ID") \
        .app_secret("YOUR_APP_SECRET") \
        .log_level(lark.LogLevel.DEBUG) \
        .build()

    # 构造请求对象
    file = open("小鸭子.jpg", "rb")
    request: CreateImageRequest = CreateImageRequest.builder() \
        .request_body(CreateImageRequestBody.builder()
            .image_type("message")
            .image(file)
            .build()) \
        .build()

    # 发起请求
    response: CreateImageResponse = client.im.v1.image.create(request)

    # 处理失败返回
    if not response.success():
        lark.logger.error(
            f"client.im.v1.image.create failed, code: {response.code}, msg: {response.msg}, log_id: {response.get_log_id()}, resp:
{json.dumps(json.loads(response.raw.content), indent=4, ensure_ascii=False)}")
        return

    # 处理业务结果
    lark.logger.info(lark.JSON.marshal(response.data, indent=4))


if __name__ == "__main__":
    main()

```

### 4. 上传文件

```python
import json

import lark_oapi as lark
from lark_oapi.api.im.v1 import *


def main():
    # 创建client
    client = lark.Client.builder() \
        .app_id("YOUR_APP_ID") \
        .app_secret("YOUR_APP_SECRET") \
        .log_level(lark.LogLevel.DEBUG) \
        .build()

    # 构造请求对象
    file = open("飞书20260129-173520.mp4", "rb")
    request: CreateFileRequest = CreateFileRequest.builder() \
        .request_body(CreateFileRequestBody.builder()
            .file_type("mp4")
            .file_name(""1.mp4"")
            .duration("3000")
            .file(file)
            .build()) \
        .build()

    # 发起请求
    response: CreateFileResponse = client.im.v1.file.create(request)

    # 处理失败返回
    if not response.success():
        lark.logger.error(
            f"client.im.v1.file.create failed, code: {response.code}, msg: {response.msg}, log_id: {response.get_log_id()}, resp:
{json.dumps(json.loads(response.raw.content), indent=4, ensure_ascii=False)}")
        return

    # 处理业务结果
    lark.logger.info(lark.JSON.marshal(response.data, indent=4))


if __name__ == "__main__":
    main()

```

### 5. 查询群成员

``` python
import json

import lark_oapi as lark
from lark_oapi.api.im.v1 import *


def main():
    # 创建client
    client = lark.Client.builder() \
        .app_id("YOUR_APP_ID") \
        .app_secret("YOUR_APP_SECRET") \
        .log_level(lark.LogLevel.DEBUG) \
        .build()

    # 构造请求对象
    request: GetChatMembersRequest = GetChatMembersRequest.builder() \
        .chat_id("oc_dcc94d101e8d41e291e90f4623eca17a") \
        .member_id_type("user_id") \
        .build()

    # 发起请求
    response: GetChatMembersResponse = client.im.v1.chat_members.get(request)

    # 处理失败返回
    if not response.success():
        lark.logger.error(
            f"client.im.v1.chat_members.get failed, code: {response.code}, msg: {response.msg}, log_id: {response.get_log_id()}, resp:
{json.dumps(json.loads(response.raw.content), indent=4, ensure_ascii=False)}")
        return

    # 处理业务结果
    lark.logger.info(lark.JSON.marshal(response.data, indent=4))


if __name__ == "__main__":
    main()

```

## 文档
- [飞书 API 文档](https://open.feishu.cn/document/server-docs/api-call-guide/server-api-list)